/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriterSegmentCopyInfo;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMOR;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Unsafe;
import io.questdb.std.WeakClosableObjectPool;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

public class TableWriterSegmentFileCache {
    private static final ObjectFactory<MemoryCMOR> GET_MEMORY_CMOR = Vm::getMemoryCMOR;
    private static final Log LOG = LogFactory.getLog(TableWriterSegmentFileCache.class);
    private final CairoConfiguration configuration;
    private final TableToken tableToken;
    private final WeakClosableObjectPool<MemoryCMOR> walColumnMemoryPool;
    private final LongObjHashMap<LongList> walFdCache = new LongObjHashMap();
    private final WeakClosableObjectPool<LongList> walFdCacheListPool = new WeakClosableObjectPool<LongList>(LongList::new, 5, true);
    private final LongObjHashMap.LongObjConsumer<LongList> walFdCloseCachedFdAction;
    private final ObjList<MemoryCMOR> walMappedColumns = new ObjList();
    private int walFdCacheSize;

    public TableWriterSegmentFileCache(TableToken tableToken, CairoConfiguration configuration) {
        this.tableToken = tableToken;
        this.configuration = configuration;
        FilesFacade ff = configuration.getFilesFacade();
        this.walColumnMemoryPool = new WeakClosableObjectPool<MemoryCMOR>(GET_MEMORY_CMOR, configuration.getWalMaxSegmentFileDescriptorsCache(), true);
        this.walFdCloseCachedFdAction = (key, fdList) -> {
            int n = fdList.size();
            for (int i = 0; i < n; ++i) {
                long fd = fdList.get(i);
                LOG.debug().$("closing wal fd cache [fd=").$(fd).I$();
                ff.close(fd);
            }
            fdList.clear();
            this.walFdCacheListPool.push((LongList)fdList);
        };
    }

    public void closeWalFiles(boolean isLastSegmentUsage, long walSegmentId, int lo) {
        boolean cacheIsFull;
        LOG.debug().$("closing wal columns [table=").$(this.tableToken).$(", walSegmentId=").$(walSegmentId).$(", isLastSegmentUsage=").$(isLastSegmentUsage).I$();
        int key = this.walFdCache.keyIndex(walSegmentId);
        boolean bl = cacheIsFull = this.walFdCacheSize >= this.configuration.getWalMaxSegmentFileDescriptorsCache();
        if (isLastSegmentUsage || cacheIsFull) {
            if (key < 0) {
                LongList fds = this.walFdCache.valueAt(key);
                this.walFdCache.removeAt(key);
                --this.walFdCacheSize;
                fds.clear();
                this.walFdCacheListPool.push(fds);
            }
            int n = this.walMappedColumns.size();
            for (int col = lo; col < n; ++col) {
                MemoryCMOR mappedColumnMem = this.walMappedColumns.get(col);
                if (mappedColumnMem == null) continue;
                Misc.free(mappedColumnMem);
                this.walColumnMemoryPool.push(mappedColumnMem);
            }
            this.walMappedColumns.setPos(lo);
        } else {
            LongList fds = null;
            if (key > -1) {
                fds = (LongList)this.walFdCacheListPool.pop();
                this.walFdCache.putAt(key, walSegmentId, fds);
                ++this.walFdCacheSize;
            }
            int n = this.walMappedColumns.size();
            for (int col = lo; col < n; ++col) {
                MemoryCMOR mappedColumnMem = this.walMappedColumns.getQuick(col);
                if (mappedColumnMem == null) continue;
                long fd = mappedColumnMem.detachFdClose();
                if (fds != null) {
                    fds.add(fd);
                }
                this.walColumnMemoryPool.push(mappedColumnMem);
            }
            this.walMappedColumns.setPos(lo);
        }
        if (cacheIsFull && lo == 0) {
            this.closeWalFiles();
        }
    }

    public void closeWalFiles(TableWriterSegmentCopyInfo segmentCopyInfo, int writerColumnCount) {
        if (this.getWalMappedColumns().size() == 0) {
            return;
        }
        for (int seg = segmentCopyInfo.getSegmentCount() - 1; seg > -1; --seg) {
            int segmentId = segmentCopyInfo.getSegmentId(seg);
            int walId = segmentCopyInfo.getWalId(seg);
            long walIdSegmentId = Numbers.encodeLowHighInts(segmentId, walId);
            boolean isLastSegmentUse = segmentCopyInfo.isLastSegmentUse(seg);
            int lo = this.getWalMappedColumns().size() - writerColumnCount * 2;
            this.closeWalFiles(isLastSegmentUse, walIdSegmentId, lo);
            if (this.getWalMappedColumns().size() == 0) break;
        }
    }

    public void closeWalFiles() {
        this.walFdCache.forEach(this.walFdCloseCachedFdAction);
        this.walFdCache.clear();
        this.walFdCacheSize = 0;
    }

    public void createAddressBuffersPrimary(int columnIndex, int columnCount, int segmentCount, long mappedAddrBuffPrimary) {
        int walColumnCountPerSegment = columnCount * 2;
        for (int i = 0; i < segmentCount; ++i) {
            MemoryCMOR segmentColumnPrimary = this.walMappedColumns.get(walColumnCountPerSegment * i + 2 * columnIndex);
            Unsafe.getUnsafe().putLong(mappedAddrBuffPrimary + (long)i * 8L, segmentColumnPrimary.addressOf(0L));
        }
    }

    public long createAddressBuffersSecondary(int columnIndex, int columnCount, TableWriterSegmentCopyInfo segmentCopyInfo, long mappedAddrBuffSecondary, ColumnTypeDriver driver) {
        int walColumnCountPerSegment = columnCount * 2;
        long totalVarSize = 0L;
        int n = segmentCopyInfo.getSegmentCount();
        for (int i = 0; i < n; ++i) {
            MemoryCMOR segmentColumnAux = this.walMappedColumns.get(walColumnCountPerSegment * i + 2 * columnIndex + 1);
            long segmentColumnAuxAddr = segmentColumnAux.addressOf(0L);
            Unsafe.getUnsafe().putLong(mappedAddrBuffSecondary + (long)i * 8L, segmentColumnAuxAddr);
            totalVarSize += driver.getDataVectorSize(segmentColumnAuxAddr, segmentCopyInfo.getRowLo(i), segmentCopyInfo.getRowHi(i) - 1L);
        }
        return totalVarSize;
    }

    public ObjList<MemoryCMOR> getWalMappedColumns() {
        return this.walMappedColumns;
    }

    public void mmapSegments(TableMetadata metadata, Path walPath, long walSegmentId, long rowLo, long rowHi) {
        int timestampIndex = metadata.getTimestampIndex();
        LOG.debug().$("open columns [table=").$(this.tableToken).$(", walSegmentId=").$(walSegmentId).I$();
        int walPathLen = walPath.size();
        int columnCount = metadata.getColumnCount();
        int fdCacheKey = this.walFdCache.keyIndex(walSegmentId);
        LongList fds = null;
        if (fdCacheKey < 0) {
            fds = this.walFdCache.valueAt(fdCacheKey);
        }
        int initialSize = this.walMappedColumns.size();
        try {
            int file = 0;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                int columnType = metadata.getColumnType(columnIndex);
                if (columnType > 0) {
                    int sizeBitsPow2 = ColumnType.getWalDataColumnShl(columnType, columnIndex == timestampIndex);
                    if (ColumnType.isVarSize(columnType)) {
                        LPSZ dfile;
                        LPSZ ifile;
                        MemoryCMOR auxMem = (MemoryCMOR)this.walColumnMemoryPool.pop();
                        MemoryCMOR dataMem = (MemoryCMOR)this.walColumnMemoryPool.pop();
                        this.walMappedColumns.add(dataMem);
                        this.walMappedColumns.add(auxMem);
                        long dataFd = fds != null ? fds.get(file++) : -1L;
                        long auxFd = fds != null ? fds.get(file++) : -1L;
                        ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                        LPSZ lPSZ = ifile = auxFd == -1L ? TableUtils.iFile(walPath, metadata.getColumnName(columnIndex), -1L) : null;
                        if (auxFd != -1L) {
                            LOG.debug().$("reusing file descriptor for WAL files [fd=").$(auxFd).$(", path=").$(walPath).$(", walSegment=").$(walSegmentId).I$();
                        }
                        columnTypeDriver.configureAuxMemOM(this.configuration.getFilesFacade(), auxMem, auxFd, ifile, rowLo, rowHi, 12, 0);
                        walPath.trimTo(walPathLen);
                        LPSZ lPSZ2 = dfile = dataFd == -1L ? TableUtils.dFile(walPath, metadata.getColumnName(columnIndex), -1L) : null;
                        if (dataFd != -1L) {
                            LOG.debug().$("reusing file descriptor for WAL files [fd=").$(dataFd).$(", wal=").$(walPath).$(", walSegment=").$(walSegmentId).I$();
                        }
                        columnTypeDriver.configureDataMemOM(this.configuration.getFilesFacade(), auxMem, dataMem, dataFd, dfile, rowLo, rowHi, 12, 0);
                    } else {
                        LPSZ dfile;
                        MemoryCMOR primary = (MemoryCMOR)this.walColumnMemoryPool.pop();
                        this.walMappedColumns.add(primary);
                        this.walMappedColumns.add(null);
                        long fd = fds != null ? fds.get(file++) : -1L;
                        LPSZ lPSZ = dfile = fd == -1L ? TableUtils.dFile(walPath, metadata.getColumnName(columnIndex), -1L) : null;
                        if (fd != -1L) {
                            LOG.debug().$("reusing file descriptor for WAL files [fd=").$(fd).$(", path=").$(walPath).$(", walSegment=").$(walSegmentId).I$();
                        }
                        primary.ofOffset(this.configuration.getFilesFacade(), fd, false, dfile, rowLo << sizeBitsPow2, rowHi << sizeBitsPow2, 12, 0);
                    }
                    walPath.trimTo(walPathLen);
                    continue;
                }
                this.walMappedColumns.add(null);
                this.walMappedColumns.add(null);
            }
        }
        catch (Throwable th) {
            this.closeWalFiles(true, walSegmentId, initialSize);
            this.walMappedColumns.setPos(initialSize);
            fds = null;
            throw th;
        }
        finally {
            if (fdCacheKey < 0) {
                this.walFdCache.removeAt(fdCacheKey);
                --this.walFdCacheSize;
            }
            if (fds != null) {
                fds.clear();
                this.walFdCacheListPool.push(fds);
            }
        }
    }

    public void mmapWalColsEager() {
        int n = this.walMappedColumns.size();
        for (int i = 0; i < n; ++i) {
            MemoryCR columnMem = this.walMappedColumns.get(i);
            if (columnMem == null) continue;
            columnMem.map();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mmapWalColumns(TableWriterSegmentCopyInfo segmentCopyInfo, TableMetadata metadata, Path path) {
        int pathSize1 = path.size();
        try {
            path.concat("wal");
            int walBaseLen = path.size();
            try {
                int n = segmentCopyInfo.getSegmentCount();
                for (int i = 0; i < n; ++i) {
                    int walId = segmentCopyInfo.getWalId(i);
                    int segmentId = segmentCopyInfo.getSegmentId(i);
                    path.trimTo(walBaseLen).put(walId).put(Files.SEPARATOR).put(segmentId);
                    long rowLo = segmentCopyInfo.getRowLo(i);
                    long rowHi = segmentCopyInfo.getRowHi(i);
                    long walIdSegmentId = Numbers.encodeLowHighInts(segmentId, walId);
                    this.mmapSegments(metadata, path, walIdSegmentId, rowLo, rowHi);
                }
            }
            catch (Throwable th) {
                Misc.freeObjListAndClear(this.walMappedColumns);
                this.closeWalFiles();
                throw th;
            }
        }
        finally {
            path.trimTo(pathSize1);
        }
    }
}

