/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.PropertyKey;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnPurgeOperator;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MPSequence;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.DirectLongList;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import io.questdb.tasks.ColumnPurgeTask;
import java.io.Closeable;

public class VacuumColumnVersions
implements Closeable {
    private static final int COLUMN_VERSION_LIST_CAPACITY = 8;
    private static final Log LOG = LogFactory.getLog(VacuumColumnVersions.class);
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final ColumnPurgeTask purgeTask = new ColumnPurgeTask();
    private final CharSequenceIntHashMap rogueColumns = new CharSequenceIntHashMap();
    private StringSink columnNameSink;
    private Utf8StringSink fileNameSink;
    private int partitionBy;
    private long partitionTimestamp;
    private Path path2;
    private ColumnPurgeOperator purgeExecution;
    private DirectLongList tableFiles;
    private int tablePathLen;
    private TableReader tableReader;
    private final FindVisitor visitTableFiles = this::visitTableFiles;
    private final FindVisitor visitTablePartition = this::visitTablePartition;

    public VacuumColumnVersions(CairoEngine engine) {
        try {
            this.engine = engine;
            this.purgeExecution = new ColumnPurgeOperator(engine);
            this.tableFiles = new DirectLongList(8L, 54);
            this.ff = engine.getConfiguration().getFilesFacade();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        this.purgeExecution = Misc.free(this.purgeExecution);
        this.tableFiles = Misc.free(this.tableFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TableReader reader) {
        if (this.engine.getCheckpointStatus().isInProgress()) {
            throw CairoException.nonCritical().put("cannot vacuum while checkpoint is in progress");
        }
        LOG.info().$("processing [table=").$(reader.getTableToken()).I$();
        this.fileNameSink = new Utf8StringSink();
        this.columnNameSink = new StringSink();
        CairoConfiguration configuration = this.engine.getConfiguration();
        TableToken tableToken = reader.getTableToken();
        Path path = Path.getThreadLocal(configuration.getDbRoot());
        path.concat(tableToken);
        this.tablePathLen = path.size();
        this.path2 = Path.getThreadLocal2(configuration.getDbRoot()).concat(tableToken);
        this.tableReader = reader;
        this.partitionBy = reader.getPartitionedBy();
        this.tableFiles.clear();
        this.rogueColumns.clear();
        try {
            this.ff.iterateDir(path.$(), this.visitTablePartition);
            Vect.sort3LongAscInPlace(this.tableFiles.getAddress(), this.tableFiles.size() / 3L);
            this.purgeColumnVersions(this.tableFiles, reader, this.engine);
        }
        finally {
            this.tableFiles.shrink(8L);
        }
    }

    private static int resolveName2Index(CharSequence name, TableReader tableReader) {
        return tableReader.getMetadata().getColumnIndexQuiet(name);
    }

    private void purgeColumnVersions(DirectLongList tableFiles, TableReader reader, CairoEngine engine) {
        int columnIndex = -1;
        int writerIndex = -1;
        int tableId = reader.getMetadata().getTableId();
        long truncateVersion = reader.getTxFile().getTruncateVersion();
        TableReaderMetadata metadata = reader.getMetadata();
        long updateTxn = reader.getTxn();
        ColumnVersionReader columnVersionReader = reader.getColumnVersionReader();
        this.purgeTask.clear();
        long n = tableFiles.size();
        for (long i = 0L; i < n; i += 3L) {
            long latestColumnNameTxn;
            int newReaderIndex;
            if (tableFiles.get(i) != (long)columnIndex && columnIndex != (newReaderIndex = (int)tableFiles.get(i))) {
                if (columnIndex != -1 && this.purgeTask.getUpdatedColumnInfo().size() > 0) {
                    if (!this.purgeExecution.purge(this.purgeTask, this.tableReader)) {
                        this.queueColumnVersionPurge(this.purgeTask, engine);
                    }
                    this.purgeTask.clear();
                }
                writerIndex = newReaderIndex > -1 ? metadata.getWriterIndex(newReaderIndex) : newReaderIndex;
                CharSequence columnName = newReaderIndex > -1 ? metadata.getColumnName(newReaderIndex) : this.rogueColumns.keys().get(-newReaderIndex - 1).toString();
                int columnType = newReaderIndex > -1 ? metadata.getColumnType(newReaderIndex) : 0;
                this.purgeTask.of(reader.getTableToken(), (String)columnName, tableId, truncateVersion, columnType, this.partitionBy, updateTxn);
            }
            columnIndex = (int)tableFiles.get(i);
            long partitionTs = tableFiles.get(i + 1L);
            long columnVersion = tableFiles.get(i + 2L);
            long l = latestColumnNameTxn = columnIndex > -1 ? columnVersionReader.getColumnNameTxn(partitionTs, writerIndex) : reader.getTxn();
            if (columnVersion == latestColumnNameTxn || columnVersion >= reader.getTxn() || this.versionSetToDelete(this.purgeTask, partitionTs, columnVersion)) continue;
            long partitionNameTxn = reader.getTxFile().getPartitionNameTxnByPartitionTimestamp(partitionTs);
            this.purgeTask.appendColumnInfo(columnVersion, partitionTs, partitionNameTxn);
        }
        if (this.purgeTask.getUpdatedColumnInfo().size() > 0) {
            if (!this.purgeExecution.purge(this.purgeTask, this.tableReader)) {
                this.queueColumnVersionPurge(this.purgeTask, engine);
            }
            this.purgeTask.clear();
        }
    }

    private void queueColumnVersionPurge(ColumnPurgeTask purgeTask, CairoEngine engine) {
        MessageBus messageBus = engine.getMessageBus();
        LOG.info().$("scheduling column version purge [table=").$(purgeTask.getTableName()).$(", column=").$(purgeTask.getColumnName()).I$();
        MPSequence pubSeq = messageBus.getColumnPurgePubSeq();
        while (true) {
            long cursor;
            if ((cursor = pubSeq.next()) > -1L) {
                ColumnPurgeTask task = messageBus.getColumnPurgeQueue().get(cursor);
                task.copyFrom(purgeTask);
                pubSeq.done(cursor);
                return;
            }
            if (cursor == -1L) {
                throw CairoException.nonCritical().put("failed to schedule column version purge, queue is full. Please retry and consider increasing ").put(PropertyKey.CAIRO_SQL_COLUMN_PURGE_QUEUE_CAPACITY.getPropertyPath()).put(" configuration parameter");
            }
            Os.pause();
        }
    }

    private boolean versionSetToDelete(ColumnPurgeTask purgeTask, long partitionTs, long columnVersion) {
        LongList columnVersionToDelete = purgeTask.getUpdatedColumnInfo();
        int n = columnVersionToDelete.size();
        for (int i = 0; i < n; i += 4) {
            long cv = columnVersionToDelete.getQuick(i + 0);
            long ts = columnVersionToDelete.getQuick(i + 1);
            if (cv != columnVersion || ts != partitionTs) continue;
            return true;
        }
        return false;
    }

    private void visitTableFiles(long pUtf8NameZ, int type) {
        if (type != 4) {
            int dotIndex;
            this.fileNameSink.clear();
            Utf8s.utf8ZCopy(pUtf8NameZ, this.fileNameSink);
            if (Files.notDots(this.fileNameSink) && (dotIndex = Utf8s.indexOfAscii(this.fileNameSink, '.')) > 0) {
                int secondDot;
                int lo;
                long columnVersion = -1L;
                this.columnNameSink.clear();
                Utf8s.utf8ToUtf16(this.fileNameSink, 0, dotIndex, this.columnNameSink);
                int name2Index = VacuumColumnVersions.resolveName2Index(this.columnNameSink, this.tableReader);
                if (name2Index < 0) {
                    if (!(Utf8s.containsAscii(this.fileNameSink, ".d.") || Utf8s.containsAscii(this.fileNameSink, ".i.") || Utf8s.containsAscii(this.fileNameSink, ".k.") || Utf8s.containsAscii(this.fileNameSink, ".v.") || Utf8s.containsAscii(this.fileNameSink, ".c.") || Utf8s.containsAscii(this.fileNameSink, ".o.") || Utf8s.endsWithAscii((Utf8Sequence)this.fileNameSink, ".d") || Utf8s.endsWithAscii((Utf8Sequence)this.fileNameSink, ".i") || Utf8s.endsWithAscii((Utf8Sequence)this.fileNameSink, ".k") || Utf8s.endsWithAscii((Utf8Sequence)this.fileNameSink, ".v") || Utf8s.endsWithAscii((Utf8Sequence)this.fileNameSink, ".c") || Utf8s.endsWithAscii((Utf8Sequence)this.fileNameSink, ".o"))) {
                        LOG.critical().$("file does not belong to the table, will be left on disk [name=").$(this.fileNameSink).$(", path=").$(this.path2).I$();
                        return;
                    }
                    int keyIndex = this.rogueColumns.keyIndex(this.columnNameSink);
                    if (keyIndex > -1) {
                        name2Index = -this.rogueColumns.keys().size() - 1;
                        this.rogueColumns.putAt(keyIndex, this.columnNameSink, name2Index);
                    } else {
                        name2Index = this.rogueColumns.valueAt(keyIndex);
                    }
                }
                if ((lo = (secondDot = Utf8s.indexOfAscii(this.fileNameSink, dotIndex + 1, '.')) + 1) < this.fileNameSink.size()) {
                    try {
                        columnVersion = Numbers.parseLong(this.fileNameSink, lo, this.fileNameSink.size());
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                }
                this.tableFiles.add(name2Index);
                this.tableFiles.add(this.partitionTimestamp);
                this.tableFiles.add(columnVersion);
            }
        }
    }

    private void visitTablePartition(long pUtf8NameZ, int type) {
        if (this.ff.isDirOrSoftLinkDirNoDots(this.path2, this.tablePathLen, pUtf8NameZ, type, this.fileNameSink)) {
            this.path2.trimTo(this.tablePathLen).$();
            int dotIndex = Utf8s.indexOfAscii(this.fileNameSink, '.');
            if (dotIndex < 0) {
                dotIndex = this.fileNameSink.size();
            }
            try {
                this.partitionTimestamp = PartitionBy.getPartitionDirFormatMethod(this.partitionBy).parse(this.fileNameSink.asAsciiCharSequence(), 0, dotIndex, DateFormatUtils.EN_LOCALE);
            }
            catch (NumericException ex) {
                LOG.error().$("skipping column version purge VACUUM, invalid partition directory name [name=").$(this.fileNameSink).$(", path=").$(this.path2).I$();
                return;
            }
            long partitionNameTxn = -1L;
            if (dotIndex + 1 < this.fileNameSink.size()) {
                try {
                    partitionNameTxn = Numbers.parseLong(this.fileNameSink, dotIndex + 1, this.fileNameSink.size());
                }
                catch (NumericException ex) {
                    LOG.error().$("skipping column version purge VACUUM, invalid partition directory name [name=").$(this.fileNameSink).$(", path=").$(this.path2).I$();
                    return;
                }
            }
            if (partitionNameTxn != this.tableReader.getTxFile().getPartitionNameTxnByPartitionTimestamp(this.partitionTimestamp)) {
                return;
            }
            this.path2.concat(pUtf8NameZ);
            LOG.info().$("enumerating files at ").$(this.path2).$();
            this.ff.iterateDir(this.path2.$(), this.visitTableFiles);
        } else {
            this.partitionTimestamp = -9223372036854775807L;
            this.visitTableFiles(pUtf8NameZ, type);
        }
    }
}

