/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.OrderedMap;
import io.questdb.cairo.map.OrderedMapRecord;
import io.questdb.cairo.map.OrderedMapValue;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.std.Hash;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OrderedMapFixedSizeRecord
implements OrderedMapRecord {
    private final long[] columnOffsets;
    private final Interval[] intervals;
    private final Long256Impl[] keyLong256A;
    private final Long256Impl[] keyLong256B;
    private final long keySize;
    private final OrderedMapValue value;
    private final long[] valueOffsets;
    private final long valueSize;
    private long keyAddress;
    private long limit;
    private IntList symbolTableIndex;
    private RecordCursor symbolTableResolver;
    private long valueAddress;

    OrderedMapFixedSizeRecord(long keySize, long valueSize, long[] valueOffsets, OrderedMapValue value, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes) {
        int size;
        int columnType;
        int i;
        int nColumns;
        int keyIndexOffset;
        assert (keySize >= 0L);
        this.keySize = keySize;
        this.valueSize = valueSize;
        this.valueOffsets = valueOffsets;
        this.value = value;
        this.value.linkRecord(this);
        if (valueTypes != null) {
            keyIndexOffset = valueTypes.getColumnCount();
            nColumns = keyTypes.getColumnCount() + valueTypes.getColumnCount();
        } else {
            keyIndexOffset = 0;
            nColumns = keyTypes.getColumnCount();
        }
        this.columnOffsets = new long[nColumns];
        Long256Impl[] long256A = null;
        Long256Impl[] long256B = null;
        Interval[] intervals = null;
        int offset = 0;
        int n = keyTypes.getColumnCount();
        for (i = 0; i < n; ++i) {
            columnType = keyTypes.getColumnType(i);
            switch (ColumnType.tagOf(columnType)) {
                case 13: {
                    if (long256A == null) {
                        long256A = new Long256Impl[nColumns];
                        long256B = new Long256Impl[nColumns];
                    }
                    long256A[i + keyIndexOffset] = new Long256Impl();
                    long256B[i + keyIndexOffset] = new Long256Impl();
                    break;
                }
                case 32: {
                    if (intervals == null) {
                        intervals = new Interval[nColumns];
                    }
                    intervals[i + keyIndexOffset] = new Interval();
                    break;
                }
            }
            size = ColumnType.sizeOf(columnType);
            if (size <= 0) {
                throw CairoException.nonCritical().put("key type is not supported: ").put(ColumnType.nameOf(columnType));
            }
            this.columnOffsets[i + keyIndexOffset] = offset;
            offset += size;
        }
        if (valueTypes != null) {
            n = valueTypes.getColumnCount();
            for (i = 0; i < n; ++i) {
                columnType = valueTypes.getColumnType(i);
                if (ColumnType.tagOf(columnType) == 13) {
                    if (long256A == null) {
                        long256A = new Long256Impl[nColumns];
                        long256B = new Long256Impl[nColumns];
                    }
                    long256A[i] = new Long256Impl();
                    long256B[i] = new Long256Impl();
                }
                if ((size = ColumnType.sizeOf(columnType)) <= 0) {
                    throw CairoException.nonCritical().put("value type is not supported: ").put(ColumnType.nameOf(columnType));
                }
                this.columnOffsets[i] = offset;
                offset += size;
            }
        }
        this.keyLong256A = long256A;
        this.keyLong256B = long256B;
        this.intervals = intervals;
    }

    private OrderedMapFixedSizeRecord(long keySize, long valueSize, long[] valueOffsets, long[] columnOffsets, Long256Impl[] keyLong256A, Long256Impl[] keyLong256B, Interval[] intervals) {
        this.keySize = keySize;
        this.valueSize = valueSize;
        this.valueOffsets = valueOffsets;
        this.columnOffsets = columnOffsets;
        this.value = new OrderedMapValue(valueSize, valueOffsets);
        this.keyLong256A = keyLong256A;
        this.keyLong256B = keyLong256B;
        this.intervals = intervals;
    }

    @Override
    public OrderedMapFixedSizeRecord clone() {
        Interval[] intervals;
        int i;
        Long256Impl[] long256B;
        Long256Impl[] long256A;
        int n;
        if (this.keyLong256A != null) {
            n = this.keyLong256A.length;
            long256A = new Long256Impl[n];
            long256B = new Long256Impl[n];
            for (i = 0; i < n; ++i) {
                if (this.keyLong256A[i] == null) continue;
                long256A[i] = new Long256Impl();
                long256B[i] = new Long256Impl();
            }
        } else {
            long256A = null;
            long256B = null;
        }
        if (this.intervals != null) {
            n = this.intervals.length;
            intervals = new Interval[n];
            for (i = 0; i < n; ++i) {
                if (this.intervals[i] == null) continue;
                intervals[i] = new Interval();
            }
        } else {
            intervals = null;
        }
        return new OrderedMapFixedSizeRecord(this.keySize, this.valueSize, this.valueOffsets, this.columnOffsets, long256A, long256B, intervals);
    }

    @Override
    public void copyToKey(MapKey destKey) {
        OrderedMap.FixedSizeKey destFastKey = (OrderedMap.FixedSizeKey)destKey;
        destFastKey.copyFromRawKey(this.keyAddress, this.keySize);
    }

    @Override
    public void copyValue(MapValue destValue) {
        OrderedMapValue destFastValue = (OrderedMapValue)destValue;
        destFastValue.copyRawValue(this.valueAddress);
    }

    @Override
    public boolean getBool(int columnIndex) {
        return Unsafe.getBool(this.addressOfColumn(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) {
        return Unsafe.getUnsafe().getByte(this.addressOfColumn(columnIndex));
    }

    @Override
    public char getChar(int columnIndex) {
        return Unsafe.getUnsafe().getChar(this.addressOfColumn(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) {
        return Unsafe.getUnsafe().getDouble(this.addressOfColumn(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) {
        return Unsafe.getUnsafe().getFloat(this.addressOfColumn(columnIndex));
    }

    @Override
    public byte getGeoByte(int columnIndex) {
        return this.getByte(columnIndex);
    }

    @Override
    public int getGeoInt(int columnIndex) {
        return this.getInt(columnIndex);
    }

    @Override
    public long getGeoLong(int columnIndex) {
        return this.getLong(columnIndex);
    }

    @Override
    public short getGeoShort(int columnIndex) {
        return this.getShort(columnIndex);
    }

    @Override
    public int getIPv4(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public Interval getInterval(int columnIndex) {
        long address = this.addressOfColumn(columnIndex);
        long lo = Unsafe.getUnsafe().getLong(address);
        long hi = Unsafe.getUnsafe().getLong(address + 8L);
        Interval interval = this.intervals[columnIndex];
        return interval.of(lo, hi);
    }

    @Override
    public long getLong(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex));
    }

    @Override
    public long getLong128Hi(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex) + 8L);
    }

    @Override
    public long getLong128Lo(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex));
    }

    @Override
    public void getLong256(int columnIndex, CharSink<?> sink) {
        Numbers.appendLong256FromUnsafe(this.addressOfColumn(columnIndex), sink);
    }

    @Override
    public Long256 getLong256A(int columnIndex) {
        return this.getLong256Generic(this.keyLong256A, columnIndex);
    }

    @Override
    public Long256 getLong256B(int columnIndex) {
        return this.getLong256Generic(this.keyLong256B, columnIndex);
    }

    @Override
    public long getRowId() {
        return this.keyAddress;
    }

    @Override
    public short getShort(int columnIndex) {
        return Unsafe.getUnsafe().getShort(this.addressOfColumn(columnIndex));
    }

    @Override
    public CharSequence getSymA(int columnIndex) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(columnIndex)).valueOf(this.getInt(columnIndex));
    }

    @Override
    public CharSequence getSymB(int columnIndex) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(columnIndex)).valueBOf(this.getInt(columnIndex));
    }

    @Override
    public MapValue getValue() {
        return this.value.of(this.keyAddress, this.valueAddress, this.limit, false);
    }

    @Override
    public long keyHashCode() {
        return Hash.hashMem64(this.keyAddress, this.keySize);
    }

    @Override
    public void of(long address) {
        this.keyAddress = address;
        this.valueAddress = address + this.keySize;
    }

    @Override
    public void setLimit(long limit) {
        this.limit = limit;
    }

    @Override
    public void setSymbolTableResolver(RecordCursor resolver, IntList symbolTableIndex) {
        this.symbolTableResolver = resolver;
        this.symbolTableIndex = symbolTableIndex;
    }

    private long addressOfColumn(int index) {
        return this.keyAddress + this.columnOffsets[index];
    }

    @NotNull
    private Long256 getLong256Generic(Long256Impl[] keyLong256, int columnIndex) {
        Long256Impl long256 = keyLong256[columnIndex];
        long256.fromAddress(this.addressOfColumn(columnIndex));
        return long256;
    }
}

