/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.TableWriter;
import io.questdb.std.NumericException;
import io.questdb.std.str.Utf8Sequence;

public class WriterRowUtils {
    private WriterRowUtils() {
    }

    public static void putGeoHash(int index, long value, int columnType, TableWriter.Row row) {
        switch (ColumnType.tagOf(columnType)) {
            case 14: {
                row.putByte(index, (byte)value);
                break;
            }
            case 15: {
                row.putShort(index, (short)value);
                break;
            }
            case 16: {
                row.putInt(index, (int)value);
                break;
            }
            default: {
                row.putLong(index, value);
            }
        }
    }

    public static void putGeoStr(int index, CharSequence hash, int type, TableWriter.Row row) {
        int typeBits;
        int charsRequired;
        if (hash == null) {
            WriterRowUtils.putGeoHash(index, -1L, type, row);
            return;
        }
        int hashLen = hash.length();
        if (hashLen < (charsRequired = ((typeBits = ColumnType.getGeoHashBits(type)) - 1) / 5 + 1)) {
            throw ImplicitCastException.inconvertibleValue(hash, 11, type);
        }
        try {
            long val = GeoHashes.widen(GeoHashes.fromString(hash, 0, charsRequired), charsRequired * 5, typeBits);
            WriterRowUtils.putGeoHash(index, val, type, row);
        }
        catch (NumericException e) {
            throw ImplicitCastException.inconvertibleValue(hash, 11, type);
        }
    }

    public static void putGeoVarchar(int index, Utf8Sequence hash, int type, TableWriter.Row row) {
        int typeBits;
        int bytesRequired;
        if (hash == null) {
            WriterRowUtils.putGeoHash(index, -1L, type, row);
            return;
        }
        int hashLen = hash.size();
        if (hashLen < (bytesRequired = ((typeBits = ColumnType.getGeoHashBits(type)) - 1) / 5 + 1)) {
            throw ImplicitCastException.inconvertibleValue(hash, 26, type);
        }
        try {
            long val = GeoHashes.widen(GeoHashes.fromAscii(hash, 0, bytesRequired), bytesRequired * 5, typeBits);
            WriterRowUtils.putGeoHash(index, val, type, row);
        }
        catch (NumericException e) {
            throw ImplicitCastException.inconvertibleValue(hash, 26, type);
        }
    }
}

