/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.std.Mutable;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Sinkable;
import org.jetbrains.annotations.NotNull;

public class HttpCookie
implements Mutable,
Sinkable {
    public DirectUtf8String cookieName;
    public DirectUtf8String domain;
    public long expires = -1L;
    public boolean httpOnly;
    public long maxAge;
    public boolean partitioned;
    public DirectUtf8String path;
    public DirectUtf8String sameSite;
    public boolean secure;
    public DirectUtf8String value;

    @Override
    public void clear() {
        this.domain = null;
        this.expires = -1L;
        this.httpOnly = false;
        this.maxAge = 0L;
        this.partitioned = false;
        this.path = null;
        this.sameSite = null;
        this.secure = false;
        this.value = null;
        this.cookieName = null;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.put('{');
        sink.put("cookieName=").putQuoted(this.cookieName);
        sink.put(", value=").putQuoted(this.value);
        if (this.domain != null) {
            sink.put(", domain=").putQuoted(this.domain);
        }
        if (this.path != null) {
            sink.put(", path=").putQuoted(this.path);
        }
        sink.put(", secure=").put(this.secure);
        sink.put(", httpOnly=").put(this.httpOnly);
        sink.put(", partitioned=").put(this.partitioned);
        sink.put(", expires=").put(this.expires);
        sink.put(", maxAge=").put(this.maxAge);
        if (this.sameSite != null) {
            sink.put(", sameSite=").putQuoted(this.sameSite);
        }
        sink.put('}');
    }

    public boolean isDeleted() {
        return this.expires == 0L;
    }
}

