/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.metrics.AtomicLongGauge;
import io.questdb.metrics.Counter;
import io.questdb.metrics.LongGauge;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.std.Mutable;

public class LineMetrics
implements Mutable {
    private final Counter aboveMaxConnectionCountCounter;
    private final Counter belowMaxConnectionCountCounter;
    private final AtomicLongGauge httpConnectionCountGauge;
    private final LongGauge tcpConnectionCountGauge;
    private final LongGauge totalIlpHttpBytesGauge;
    private final LongGauge totalIlpTcpBytesGauge;

    public LineMetrics(MetricsRegistry metricsRegistry) {
        this.httpConnectionCountGauge = metricsRegistry.newAtomicLongGauge("line_http_connections");
        this.tcpConnectionCountGauge = metricsRegistry.newLongGauge("line_tcp_connections");
        this.totalIlpTcpBytesGauge = metricsRegistry.newLongGauge("line_tcp_recv_bytes");
        this.totalIlpHttpBytesGauge = metricsRegistry.newLongGauge("line_http_recv_bytes");
        this.aboveMaxConnectionCountCounter = metricsRegistry.newCounter("line_tcp_above_max_connection_count");
        this.belowMaxConnectionCountCounter = metricsRegistry.newCounter("line_tcp_below_max_connection_count");
    }

    public Counter aboveMaxConnectionCountCounter() {
        return this.aboveMaxConnectionCountCounter;
    }

    public Counter belowMaxConnectionCountCounter() {
        return this.belowMaxConnectionCountCounter;
    }

    @Override
    public void clear() {
        this.httpConnectionCountGauge.setValue(0L);
        this.tcpConnectionCountGauge.setValue(0L);
        this.totalIlpTcpBytesGauge.setValue(0L);
        this.totalIlpHttpBytesGauge.setValue(0L);
        this.aboveMaxConnectionCountCounter.reset();
        this.belowMaxConnectionCountCounter.reset();
    }

    public AtomicLongGauge httpConnectionCountGauge() {
        return this.httpConnectionCountGauge;
    }

    public LongGauge tcpConnectionCountGauge() {
        return this.tcpConnectionCountGauge;
    }

    public LongGauge totalIlpHttpBytesGauge() {
        return this.totalIlpHttpBytesGauge;
    }

    public LongGauge totalIlpTcpBytesGauge() {
        return this.totalIlpTcpBytesGauge;
    }
}

