/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DerivedArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class DoubleArraySubtractFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "-(D[]D[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(configuration, args.getQuick(0), args.getQuick(1), argPositions.getQuick(0));
    }

    private static class Func
    extends ArrayFunction
    implements BinaryFunction {
        private final DirectArray arrayOut;
        private final Function leftArg;
        private final int leftArgPos;
        private final DerivedArrayView leftArgView = new DerivedArrayView();
        private final String opName;
        private final Function rightArg;
        private final DerivedArrayView rightArgView = new DerivedArrayView();

        private Func(CairoConfiguration configuration, Function leftArg, Function rightArg, int leftArgPos) {
            this.opName = "-";
            this.leftArg = leftArg;
            this.rightArg = rightArg;
            this.arrayOut = new DirectArray(configuration);
            this.leftArgPos = leftArgPos;
            int nDimsLeft = ColumnType.decodeArrayDimensionality(leftArg.getType());
            int nDimsRight = ColumnType.decodeArrayDimensionality(rightArg.getType());
            this.type = ColumnType.encodeArrayType((short)10, Math.max(nDimsLeft, nDimsRight));
        }

        @Override
        public void close() {
            BinaryFunction.super.close();
            Misc.free(this.arrayOut);
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView left = this.leftArg.getArray(rec);
            ArrayView right = this.rightArg.getArray(rec);
            if (left.isNull() || right.isNull()) {
                this.arrayOut.ofNull();
                return this.arrayOut;
            }
            this.arrayOut.setType(this.type);
            if (left.shapeDiffers(right)) {
                DerivedArrayView.computeBroadcastShape(left, right, this.arrayOut.getShape(), this.leftArgPos);
                if (left.shapeDiffers(this.arrayOut)) {
                    this.leftArgView.of(left);
                    this.leftArgView.broadcast(this.arrayOut.getShape());
                    left = this.leftArgView;
                }
                if (right.shapeDiffers(this.arrayOut)) {
                    this.rightArgView.of(right);
                    this.rightArgView.broadcast(this.arrayOut.getShape());
                    right = this.rightArgView;
                }
            } else {
                this.arrayOut.copyShapeFrom(left);
            }
            this.arrayOut.applyShape();
            if (left.isVanilla() && right.isVanilla()) {
                int n = left.getFlatViewLength();
                for (int i = 0; i < n; ++i) {
                    this.arrayOut.putDouble(i, left.getDouble(i) - right.getDouble(i));
                }
            } else {
                Func.applyRecursive(0, left, 0, right, 0, this.arrayOut.startMemoryA());
            }
            return this.arrayOut;
        }

        @Override
        public Function getLeft() {
            return this.leftArg;
        }

        @Override
        public String getName() {
            return this.opName;
        }

        @Override
        public Function getRight() {
            return this.rightArg;
        }

        @Override
        public boolean isOperator() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static void applyRecursive(int dim, ArrayView left, int flatIndexLeft, ArrayView right, int flatIndexRight, MemoryA memOut) {
            boolean atDeepestDim;
            int count = left.getDimLen(dim);
            int strideLeft = left.getStride(dim);
            int strideRight = right.getStride(dim);
            boolean bl = atDeepestDim = dim == left.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    double leftVal = left.getDouble(flatIndexLeft);
                    double rightVal = right.getDouble(flatIndexRight);
                    memOut.putDouble(leftVal - rightVal);
                    flatIndexLeft += strideLeft;
                    flatIndexRight += strideRight;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    Func.applyRecursive(dim + 1, left, flatIndexLeft, right, flatIndexRight, memOut);
                    flatIndexLeft += strideLeft;
                    flatIndexRight += strideRight;
                }
            }
        }
    }
}

