/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastSymbolToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ks)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function func = args.getQuick(0);
        if (func.isConstant()) {
            return new StrConstant(Chars.toString(func.getSymbol(null)));
        }
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToStrFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.arg.getSymbol(rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.arg.getSymbolB(rec);
        }

        @Override
        public boolean isThreadSafe() {
            return this.arg.isThreadSafe();
        }
    }
}

