/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Chars;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;

public class StrConstant
extends StrFunction
implements ConstantFunction {
    public static final StrConstant EMPTY = new StrConstant("");
    public static final StrConstant NULL = new StrConstant(null);
    private final int length;
    private final Utf8String utf8Value;
    private final String value;

    public StrConstant(CharSequence value) {
        if (value == null) {
            this.value = null;
            this.utf8Value = null;
            this.length = -1;
        } else {
            this.value = Chars.startsWith(value, '\'') ? Chars.toString(value, 1, value.length() - 1, value.charAt(0)) : Chars.toString(value);
            this.utf8Value = new Utf8String(this.value);
            this.length = this.value.length();
        }
    }

    public static StrConstant newInstance(CharSequence value) {
        return value != null ? new StrConstant(value) : NULL;
    }

    @Override
    public CharSequence getStrA(Record rec) {
        return this.value;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.value;
    }

    @Override
    public int getStrLen(Record rec) {
        return this.length;
    }

    @Override
    public Utf8Sequence getVarcharA(Record rec) {
        return this.utf8Value;
    }

    @Override
    public Utf8Sequence getVarcharB(Record rec) {
        return this.utf8Value;
    }

    @Override
    public int getVarcharSize(Record rec) {
        return this.utf8Value != null ? this.utf8Value.size() : -1;
    }

    @Override
    public boolean isNullConstant() {
        return this.value == null;
    }

    @Override
    public void toPlan(PlanSink sink) {
        if (this.value == null) {
            sink.val("null");
        } else {
            sink.val('\'').val(this.value).val('\'');
        }
    }
}

