/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.FunctionExtension;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntervalFunction;
import io.questdb.griffin.engine.functions.constants.IntervalConstant;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class IntervalFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "interval(NN)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function loFunc = args.getQuick(0);
        Function hiFunc = args.getQuick(1);
        if (loFunc.isConstant() && hiFunc.isConstant()) {
            long lo = loFunc.getTimestamp(null);
            long hi = hiFunc.getTimestamp(null);
            if (lo == Long.MIN_VALUE || hi == Long.MIN_VALUE) {
                return IntervalConstant.NULL;
            }
            if (lo > hi) {
                throw SqlException.position(position).put("invalid interval boundaries");
            }
            return IntervalConstant.newInstance(lo, hi);
        }
        if (loFunc.isConstant() || loFunc.isRuntimeConstant() || hiFunc.isConstant() || hiFunc.isRuntimeConstant()) {
            return new RuntimeConstFunc(position, loFunc, hiFunc);
        }
        return new Func(loFunc, hiFunc);
    }

    private static class RuntimeConstFunc
    extends IntervalFunction
    implements BinaryFunction,
    FunctionExtension {
        private final Function hiFunc;
        private final Interval interval = new Interval();
        private final Function loFunc;
        private final int position;

        public RuntimeConstFunc(int position, Function loFunc, Function hiFunc) {
            this.position = position;
            this.loFunc = loFunc;
            this.hiFunc = hiFunc;
        }

        @Override
        public FunctionExtension extendedOps() {
            return this;
        }

        @Override
        public int getArrayLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Interval getInterval(Record rec) {
            return this.interval;
        }

        @Override
        public Function getLeft() {
            return this.loFunc;
        }

        @Override
        public String getName() {
            return "interval";
        }

        @Override
        public Record getRecord(Record rec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Function getRight() {
            return this.hiFunc;
        }

        @Override
        public CharSequence getStrA(Record rec, int arrayIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence getStrB(Record rec, int arrayIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStrLen(Record rec, int arrayIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            long lo = this.loFunc.getTimestamp(null);
            long hi = this.hiFunc.getTimestamp(null);
            if (lo == Long.MIN_VALUE || hi == Long.MIN_VALUE) {
                this.interval.of(Interval.NULL.getLo(), Interval.NULL.getHi());
            }
            if (lo > hi) {
                throw SqlException.position(this.position).put("invalid interval boundaries");
            }
            this.interval.of(lo, hi);
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isRuntimeConstant() {
            return true;
        }
    }

    private static class Func
    extends IntervalFunction
    implements BinaryFunction,
    FunctionExtension {
        private final Function hiFunc;
        private final Interval interval = new Interval();
        private final Function loFunc;

        public Func(Function loFunc, Function hiFunc) {
            this.loFunc = loFunc;
            this.hiFunc = hiFunc;
        }

        @Override
        public FunctionExtension extendedOps() {
            return this;
        }

        @Override
        public int getArrayLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Interval getInterval(Record rec) {
            long l = this.loFunc.getTimestamp(rec);
            long r = this.hiFunc.getTimestamp(rec);
            if (l == Long.MIN_VALUE || r == Long.MIN_VALUE) {
                return Interval.NULL;
            }
            if (l > r) {
                throw CairoException.nonCritical().put("invalid interval boundaries");
            }
            return this.interval.of(l, r);
        }

        @Override
        public Function getLeft() {
            return this.loFunc;
        }

        @Override
        public String getName() {
            return "interval";
        }

        @Override
        public Record getRecord(Record rec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Function getRight() {
            return this.hiFunc;
        }

        @Override
        public CharSequence getStrA(Record rec, int arrayIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence getStrB(Record rec, int arrayIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStrLen(Record rec, int arrayIndex) {
            throw new UnsupportedOperationException();
        }
    }
}

