/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SystimestampFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "systimestamp()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(sqlExecutionContext);
    }

    private static class Func
    extends TimestampFunction
    implements Function {
        private final SqlExecutionContext context;

        public Func(SqlExecutionContext context) {
            this.context = context;
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.context.getMicrosecondTimestamp();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(SystimestampFunctionFactory.SIGNATURE);
        }
    }
}

