/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.QuaternaryFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.date.TimestampAddFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;

public class TimestampAddWithTimezoneFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "dateadd(AINS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function periodFunc = args.getQuick(0);
        Function strideFunc = args.getQuick(1);
        Function timestampFunc = args.getQuick(2);
        Function tzFunc = args.getQuick(3);
        if (periodFunc.isConstant() && tzFunc.isConstant()) {
            TimeZoneRules timeZoneRules;
            try {
                timeZoneRules = Timestamps.getTimezoneRules(TimestampFormatUtils.EN_LOCALE, tzFunc.getStrA(null));
            }
            catch (NumericException e) {
                throw SqlException.position(argPositions.getQuick(3)).put("invalid timezone [timezone=").put(tzFunc.getStrA(null)).put(']');
            }
            char period = periodFunc.getChar(null);
            TimestampAddFunctionFactory.LongAddIntFunction periodAddFunc = TimestampAddFunctionFactory.lookupAddFunction(period);
            if (periodAddFunc == null) {
                throw SqlException.$(argPositions.getQuick(0), "invalid time period [unit=").put(period).put(']');
            }
            if (strideFunc.isConstant()) {
                int stride = strideFunc.getInt(null);
                if (stride != Integer.MIN_VALUE) {
                    return new TimestampAddConstConstVarConst(period, periodAddFunc, stride, timestampFunc, timeZoneRules, tzFunc);
                }
                throw SqlException.$(argPositions.getQuick(1), "`null` is not a valid stride");
            }
            return new TimestampAddConstVarVarConst(period, periodAddFunc, strideFunc, argPositions.getQuick(1), timestampFunc, timeZoneRules, tzFunc);
        }
        return new TimestampAddFunc(periodFunc, argPositions.getQuick(0), strideFunc, argPositions.getQuick(1), timestampFunc, tzFunc, argPositions.getQuick(3));
    }

    private static long compute(long timestamp, TimeZoneRules timeZoneRules, int stride, TimestampAddFunctionFactory.LongAddIntFunction periodAddFunction) {
        if (timestamp == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        long offset = timeZoneRules.getOffset(timestamp);
        long localTimestamp = periodAddFunction.add(timestamp + offset, stride);
        return localTimestamp - timeZoneRules.getLocalOffset(localTimestamp);
    }

    private static class TimestampAddConstConstVarConst
    extends TimestampFunction
    implements UnaryFunction {
        private final char period;
        private final TimestampAddFunctionFactory.LongAddIntFunction periodAddFunction;
        private final int stride;
        private final TimeZoneRules timeZoneRules;
        private final Function timestampFunc;
        private final Function tzFunc;

        public TimestampAddConstConstVarConst(char period, TimestampAddFunctionFactory.LongAddIntFunction periodAddFunction, int stride, Function timestampFunc, TimeZoneRules timeZoneRules, Function tzFunc) {
            this.period = period;
            this.periodAddFunction = periodAddFunction;
            this.stride = stride;
            this.timestampFunc = timestampFunc;
            this.timeZoneRules = timeZoneRules;
            this.tzFunc = tzFunc;
        }

        @Override
        public Function getArg() {
            return this.timestampFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            return TimestampAddWithTimezoneFunctionFactory.compute(this.timestampFunc.getTimestamp(rec), this.timeZoneRules, this.stride, this.periodAddFunction);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("dateadd('").val(this.period).val("',").val(this.stride).val(',').val(this.timestampFunc).val(',').val(this.tzFunc).val(')');
        }
    }

    private static class TimestampAddConstVarVarConst
    extends TimestampFunction
    implements TernaryFunction {
        private final char period;
        private final TimestampAddFunctionFactory.LongAddIntFunction periodAddFunc;
        private final Function strideFunc;
        private final int stridePosition;
        private final TimeZoneRules timeZoneRules;
        private final Function timestampFunc;
        private final Function tzFunc;

        public TimestampAddConstVarVarConst(char period, TimestampAddFunctionFactory.LongAddIntFunction periodAddFunc, Function strideFunc, int stridePosition, Function timestampFunc, TimeZoneRules timeZoneRules, Function tzFunc) {
            this.period = period;
            this.periodAddFunc = periodAddFunc;
            this.strideFunc = strideFunc;
            this.stridePosition = stridePosition;
            this.timestampFunc = timestampFunc;
            this.timeZoneRules = timeZoneRules;
            this.tzFunc = tzFunc;
        }

        @Override
        public Function getCenter() {
            return this.tzFunc;
        }

        @Override
        public Function getLeft() {
            return this.timestampFunc;
        }

        @Override
        public Function getRight() {
            return this.strideFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            long timestamp = this.timestampFunc.getTimestamp(rec);
            int stride = this.strideFunc.getInt(rec);
            if (stride == Integer.MIN_VALUE) {
                throw CairoException.nonCritical().position(this.stridePosition).put("`null` is not a valid stride");
            }
            return TimestampAddWithTimezoneFunctionFactory.compute(timestamp, this.timeZoneRules, stride, this.periodAddFunc);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("dateadd('").val(this.period).val("',").val(this.timestampFunc).val(',').val(this.strideFunc).val(',').val(this.tzFunc).val(')');
        }
    }

    private static class TimestampAddFunc
    extends TimestampFunction
    implements QuaternaryFunction {
        private final Function periodFunc;
        private final int periodPosition;
        private final Function strideFunc;
        private final int stridePosition;
        private final Function timestampFunc;
        private final int timezonePosition;
        private final Function tzFunc;

        public TimestampAddFunc(Function periodFunc, int periodPosition, Function strideFunc, int stridePosition, Function timestampFunc, Function tzFunc, int timezonePosition) {
            this.periodFunc = periodFunc;
            this.periodPosition = periodPosition;
            this.strideFunc = strideFunc;
            this.stridePosition = stridePosition;
            this.timestampFunc = timestampFunc;
            this.tzFunc = tzFunc;
            this.timezonePosition = timezonePosition;
        }

        @Override
        public Function getFunc0() {
            return this.timestampFunc;
        }

        @Override
        public Function getFunc1() {
            return this.strideFunc;
        }

        @Override
        public Function getFunc2() {
            return this.periodFunc;
        }

        @Override
        public Function getFunc3() {
            return this.tzFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            TimeZoneRules timeZoneRules;
            long timestamp = this.timestampFunc.getTimestamp(rec);
            int stride = this.strideFunc.getInt(rec);
            char period = this.periodFunc.getChar(rec);
            CharSequence tz = this.tzFunc.getStrA(rec);
            if (timestamp == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (stride == Integer.MIN_VALUE) {
                throw CairoException.nonCritical().position(this.stridePosition).put("`null` is not a valid stride");
            }
            if (tz == null) {
                throw CairoException.nonCritical().position(this.timezonePosition).put("NULL timezone");
            }
            try {
                timeZoneRules = Timestamps.getTimezoneRules(TimestampFormatUtils.EN_LOCALE, tz);
            }
            catch (NumericException e) {
                throw CairoException.nonCritical().position(this.timezonePosition).put("invalid timezone [timezone=").put(tz).put(']');
            }
            TimestampAddFunctionFactory.LongAddIntFunction periodAddFunc = TimestampAddFunctionFactory.lookupAddFunction(period);
            if (periodAddFunc == null) {
                throw CairoException.nonCritical().position(this.periodPosition).put("invalid period [period=").put(period).put(']');
            }
            return TimestampAddWithTimezoneFunctionFactory.compute(timestamp, timeZoneRules, stride, periodAddFunc);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("dateadd('").val(this.periodFunc).val("',").val(this.strideFunc).val(',').val(this.timestampFunc).val(',').val(this.tzFunc).val(')');
        }
    }
}

