/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionByte;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionInt;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionLong;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionShort;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class FirstNotNullGeoHashGroupByFunctionFactory
implements FunctionFactory {
    public static final String NAME = "first_not_null";

    @Override
    public String getSignature() {
        return "first_not_null(G)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function function = args.getQuick(0);
        int type = function.getType();
        switch (ColumnType.tagOf(type)) {
            case 14: {
                return new FirstNotNullGeoHashGroupByFunctionByte(type, function);
            }
            case 15: {
                return new FirstNotNullGeoHashGroupByFunctionShort(type, function);
            }
            case 16: {
                return new FirstNotNullGeoHashGroupByFunctionInt(type, function);
            }
        }
        return new FirstNotNullGeoHashGroupByFunctionLong(type, function);
    }

    private static class FirstNotNullGeoHashGroupByFunctionByte
    extends FirstGeoHashGroupByFunctionByte {
        public FirstNotNullGeoHashGroupByFunctionByte(int type, Function function) {
            super(type, function);
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            if (mapValue.getGeoByte(this.valueIndex + 1) == -1) {
                this.computeFirst(mapValue, record, rowId);
            }
        }

        @Override
        public String getName() {
            return FirstNotNullGeoHashGroupByFunctionFactory.NAME;
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            long destRowId;
            byte srcVal = srcValue.getGeoByte(this.valueIndex + 1);
            if (srcVal == -1) {
                return;
            }
            long srcRowId = srcValue.getLong(this.valueIndex);
            if (srcRowId < (destRowId = destValue.getLong(this.valueIndex)) || destRowId == Long.MIN_VALUE) {
                destValue.putLong(this.valueIndex, srcRowId);
                destValue.putByte(this.valueIndex + 1, srcVal);
            }
        }
    }

    private static class FirstNotNullGeoHashGroupByFunctionShort
    extends FirstGeoHashGroupByFunctionShort {
        public FirstNotNullGeoHashGroupByFunctionShort(int type, Function function) {
            super(type, function);
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            if (mapValue.getGeoShort(this.valueIndex + 1) == -1) {
                this.computeFirst(mapValue, record, rowId);
            }
        }

        @Override
        public String getName() {
            return FirstNotNullGeoHashGroupByFunctionFactory.NAME;
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            long destRowId;
            short srcVal = srcValue.getGeoShort(this.valueIndex + 1);
            if (srcVal == -1) {
                return;
            }
            long srcRowId = srcValue.getLong(this.valueIndex);
            if (srcRowId < (destRowId = destValue.getLong(this.valueIndex)) || destRowId == Long.MIN_VALUE) {
                destValue.putLong(this.valueIndex, srcRowId);
                destValue.putShort(this.valueIndex + 1, srcVal);
            }
        }
    }

    private static class FirstNotNullGeoHashGroupByFunctionInt
    extends FirstGeoHashGroupByFunctionInt {
        public FirstNotNullGeoHashGroupByFunctionInt(int type, Function function) {
            super(type, function);
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            if (mapValue.getGeoInt(this.valueIndex + 1) == -1) {
                this.computeFirst(mapValue, record, rowId);
            }
        }

        @Override
        public String getName() {
            return FirstNotNullGeoHashGroupByFunctionFactory.NAME;
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            long destRowId;
            int srcVal = srcValue.getGeoInt(this.valueIndex + 1);
            if (srcVal == -1) {
                return;
            }
            long srcRowId = srcValue.getLong(this.valueIndex);
            if (srcRowId < (destRowId = destValue.getLong(this.valueIndex)) || destRowId == Long.MIN_VALUE) {
                destValue.putLong(this.valueIndex, srcRowId);
                destValue.putInt(this.valueIndex + 1, srcVal);
            }
        }
    }

    private static class FirstNotNullGeoHashGroupByFunctionLong
    extends FirstGeoHashGroupByFunctionLong {
        public FirstNotNullGeoHashGroupByFunctionLong(int type, Function function) {
            super(type, function);
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            if (mapValue.getGeoLong(this.valueIndex + 1) == -1L) {
                this.computeFirst(mapValue, record, rowId);
            }
        }

        @Override
        public String getName() {
            return FirstNotNullGeoHashGroupByFunctionFactory.NAME;
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            long destRowId;
            long srcVal = srcValue.getGeoLong(this.valueIndex + 1);
            if (srcVal == -1L) {
                return;
            }
            long srcRowId = srcValue.getLong(this.valueIndex);
            if (srcRowId < (destRowId = destValue.getLong(this.valueIndex)) || destRowId == Long.MIN_VALUE) {
                destValue.putLong(this.valueIndex, srcRowId);
                destValue.putLong(this.valueIndex + 1, srcVal);
            }
        }
    }
}

