/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectUtf16Sink;

class StringAggGroupByFunction
extends StrFunction
implements UnaryFunction,
GroupByFunction {
    private static final int INITIAL_SINK_CAPACITY = 512;
    private static final int LIST_CLEAR_THRESHOLD = 64;
    private final Function arg;
    private final char delimiter;
    private final int functionPosition;
    private final int maxBytes;
    private final ObjList<DirectUtf16Sink> sinks = new ObjList();
    private int sinkIndex = 0;
    private int touchedMemorySize;
    private int valueIndex;

    public StringAggGroupByFunction(Function arg, int functionPosition, char delimiter, int maxBytes) {
        this.arg = arg;
        this.delimiter = delimiter;
        this.maxBytes = maxBytes;
        this.functionPosition = functionPosition;
    }

    @Override
    public void clear() {
        int i;
        this.touchedMemorySize = 0;
        if (this.sinks.size() > 64) {
            for (i = this.sinks.size() - 1; i > 63; --i) {
                Misc.free(this.sinks.getQuick(i));
                this.sinks.remove(i);
            }
        }
        int n = this.sinks.size();
        for (i = 0; i < n; ++i) {
            DirectUtf16Sink sink = this.sinks.getQuick(i);
            if (sink == null) continue;
            sink.resetCapacity();
            this.touchedMemorySize += sink.size();
        }
        this.sinkIndex = 0;
    }

    @Override
    public void close() {
        Misc.freeObjListAndClear(this.sinks);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        DirectUtf16Sink sink;
        if (this.sinks.size() <= this.sinkIndex) {
            sink = new DirectUtf16Sink(512L);
            this.sinks.extendAndSet(this.sinkIndex, sink);
        } else {
            sink = this.sinks.getQuick(this.sinkIndex);
            sink.clear();
        }
        CharSequence str = this.arg.getStrA(record);
        if (str != null) {
            sink.put(str);
            mapValue.putBool(this.valueIndex + 1, false);
        } else {
            mapValue.putBool(this.valueIndex + 1, true);
        }
        mapValue.putInt(this.valueIndex, this.sinkIndex++);
        this.touchedMemorySize += sink.size();
        this.assertTouchedMemoryCompliance();
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        DirectUtf16Sink sink = this.sinks.getQuick(mapValue.getInt(this.valueIndex));
        CharSequence str = this.arg.getStrA(record);
        if (str != null) {
            int hi = sink.size();
            boolean nullValue = mapValue.getBool(this.valueIndex + 1);
            if (!nullValue) {
                sink.putAscii(this.delimiter);
            }
            sink.put(str);
            mapValue.putBool(this.valueIndex + 1, false);
            this.touchedMemorySize += sink.size() - hi;
            this.assertTouchedMemoryCompliance();
        }
    }

    private void assertTouchedMemoryCompliance() {
        if (this.touchedMemorySize > this.maxBytes) {
            throw CairoException.nonCritical().position(this.functionPosition).put("string_agg() result exceeds max size of ").put(this.maxBytes).put(" bytes");
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public CharSequence getStrA(Record rec) {
        boolean nullValue = rec.getBool(this.valueIndex + 1);
        if (nullValue) {
            return null;
        }
        return this.sinks.getQuick(rec.getInt(this.valueIndex));
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.getStrA(rec);
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(5);
        columnTypes.add(1);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putBool(this.valueIndex + 1, true);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("string_agg(").val(this.arg).val(',').val(this.delimiter).val(')');
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
        this.sinkIndex = 0;
    }
}

