/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class SumDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    public SumDoubleGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        double value = this.arg.getDouble(record);
        if (Numbers.isFinite(value)) {
            mapValue.putDouble(this.valueIndex, value);
            mapValue.putLong(this.valueIndex + 1, 1L);
        } else {
            mapValue.putDouble(this.valueIndex, 0.0);
            mapValue.putLong(this.valueIndex + 1, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        double value = this.arg.getDouble(record);
        if (Numbers.isFinite(value)) {
            mapValue.addDouble(this.valueIndex, value);
            mapValue.addLong(this.valueIndex + 1, 1L);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public double getDouble(Record rec) {
        long valueCount = rec.getLong(this.valueIndex + 1);
        if (valueCount > 0L) {
            return rec.getDouble(this.valueIndex);
        }
        return Double.NaN;
    }

    @Override
    public String getName() {
        return "sum";
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
        columnTypes.add(6);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        double srcSum = srcValue.getDouble(this.valueIndex);
        long srcCount = srcValue.getLong(this.valueIndex + 1);
        destValue.addDouble(this.valueIndex, srcSum);
        destValue.addLong(this.valueIndex + 1, srcCount);
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
        mapValue.putLong(this.valueIndex + 1, 1L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
        mapValue.putLong(this.valueIndex + 1, 0L);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

