/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.json;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.json.JsonExtractSupportingState;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.BinarySequence;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonExtractFunction
implements Function {
    private static final boolean defaultBool = false;
    private final Function json;
    private final int maxSize;
    private final Function path;
    @NotNull
    private final JsonExtractSupportingState stateA;
    @Nullable
    private final JsonExtractSupportingState stateB;
    private final int targetType;
    private DirectUtf8Sink pointer;

    public JsonExtractFunction(int targetType, Function json, Function path, int maxSize) {
        this.targetType = targetType;
        this.json = json;
        this.path = path;
        this.maxSize = maxSize;
        switch (targetType) {
            case 7: 
            case 8: 
            case 25: {
                this.stateA = new JsonExtractSupportingState(new DirectUtf8Sink(maxSize, false), false);
                this.stateB = null;
                break;
            }
            case 26: {
                this.stateA = new JsonExtractSupportingState(new DirectUtf8Sink(maxSize, false), true);
                this.stateB = new JsonExtractSupportingState(new DirectUtf8Sink(maxSize, false), true);
                break;
            }
            default: {
                this.stateA = new JsonExtractSupportingState(null, false);
                this.stateB = null;
            }
        }
    }

    @Override
    public boolean shouldMemoize() {
        return true;
    }

    @Override
    public void close() {
        Misc.free(this.stateA);
        Misc.free(this.stateB);
        this.pointer = Misc.free(this.pointer);
        this.json.close();
        this.path.close();
    }

    @Override
    public void cursorClosed() {
        this.stateA.deflate();
        if (this.stateB != null) {
            this.stateB.deflate();
        }
    }

    @Override
    public ArrayView getArray(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BinarySequence getBin(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBinLen(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBool(Record rec) {
        Utf8Sequence jsonSeq = this.json.getVarcharA(rec);
        if (jsonSeq == null || this.pointer == null) {
            return false;
        }
        return this.stateA.parser.queryPointerBoolean(this.stateA.initPaddedJson(jsonSeq), this.pointer, this.stateA.simdJsonResult);
    }

    @Override
    public final byte getByte(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char getChar(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDate(Record rec) {
        Utf8Sequence jsonInput = this.json.getVarcharA(rec);
        if (jsonInput == null || this.pointer == null) {
            return Long.MIN_VALUE;
        }
        long res = this.queryPointerValue(jsonInput);
        switch (this.stateA.simdJsonResult.getType()) {
            case 4: {
                assert (this.stateA.destUtf8Sink != null);
                try {
                    return DateFormatUtils.parseDate(this.stateA.destUtf8Sink.asAsciiCharSequence());
                }
                catch (NumericException e) {
                    return Long.MIN_VALUE;
                }
            }
            case 3: {
                return this.extractLongFromJsonNumber(res);
            }
        }
        return Long.MIN_VALUE;
    }

    @Override
    public double getDouble(Record rec) {
        Utf8Sequence jsonSeq = this.json.getVarcharA(rec);
        if (jsonSeq == null || this.pointer == null) {
            return Double.NaN;
        }
        double d = this.stateA.parser.queryPointerDouble(this.stateA.initPaddedJson(jsonSeq), this.pointer, this.stateA.simdJsonResult);
        if (this.stateA.simdJsonResult.getError() == 0) {
            return d;
        }
        return Double.NaN;
    }

    @Override
    public float getFloat(Record rec) {
        return (float)this.getDouble(rec);
    }

    @Override
    public byte getGeoByte(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGeoInt(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getGeoLong(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getGeoShort(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIPv4(Record rec) {
        Utf8Sequence jsonInput = this.json.getVarcharA(rec);
        if (jsonInput == null || this.pointer == null) {
            return 0;
        }
        long res = this.queryPointerValue(jsonInput);
        switch (this.stateA.simdJsonResult.getType()) {
            case 4: {
                assert (this.stateA.destUtf8Sink != null);
                return Numbers.parseIPv4Quiet(this.stateA.destUtf8Sink.asAsciiCharSequence());
            }
            case 3: {
                int asInt;
                if (this.stateA.simdJsonResult.getNumberType() == 2 && (long)(asInt = (int)res) == res) {
                    return asInt;
                }
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int getInt(Record rec) {
        Utf8Sequence jsonSeq = this.json.getVarcharA(rec);
        if (jsonSeq == null || this.pointer == null) {
            return Integer.MIN_VALUE;
        }
        return this.stateA.parser.queryPointerInt(this.stateA.initPaddedJson(jsonSeq), this.pointer, this.stateA.simdJsonResult);
    }

    @Override
    @NotNull
    public Interval getInterval(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(Record rec) {
        Utf8Sequence jsonSeq = this.json.getVarcharA(rec);
        if (jsonSeq == null || this.pointer == null) {
            return Long.MIN_VALUE;
        }
        return this.stateA.parser.queryPointerLong(this.stateA.initPaddedJson(jsonSeq), this.pointer, this.stateA.simdJsonResult);
    }

    @Override
    public long getLong128Hi(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong128Lo(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getLong256(Record rec, CharSink<?> sink) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long256 getLong256A(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long256 getLong256B(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "json_extract";
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(Record rec) {
        Utf8Sequence jsonSeq = this.json.getVarcharA(rec);
        if (jsonSeq == null || this.pointer == null) {
            return 0;
        }
        return this.stateA.parser.queryPointerShort(this.stateA.initPaddedJson(jsonSeq), this.pointer, this.stateA.simdJsonResult);
    }

    @Override
    public CharSequence getStrA(Record rec) {
        DirectUtf8Sink utf8seq = this.getVarcharA(rec);
        if (utf8seq == null) {
            return null;
        }
        if (utf8seq.isAscii()) {
            return utf8seq.asAsciiCharSequence();
        }
        assert (this.stateA.destUtf16Sink != null);
        this.stateA.destUtf16Sink.clear();
        Utf8s.utf8ToUtf16(utf8seq, this.stateA.destUtf16Sink);
        return this.stateA.destUtf16Sink;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        DirectUtf8Sink utf8seq = this.getVarcharB(rec);
        if (utf8seq == null) {
            return null;
        }
        if (utf8seq.isAscii()) {
            return utf8seq.asAsciiCharSequence();
        }
        assert (this.stateB != null);
        assert (this.stateB.destUtf16Sink != null);
        this.stateB.destUtf16Sink.clear();
        Utf8s.utf8ToUtf16(utf8seq, this.stateB.destUtf16Sink);
        return this.stateB.destUtf16Sink;
    }

    @Override
    public int getStrLen(Record rec) {
        return TableUtils.lengthOf(this.getStrA(rec));
    }

    @Override
    public final CharSequence getSymbol(Record rec) {
        return this.getStrA(rec);
    }

    @Override
    public final CharSequence getSymbolB(Record rec) {
        return this.getStrB(rec);
    }

    @Override
    public long getTimestamp(Record rec) {
        Utf8Sequence jsonInput = this.json.getVarcharA(rec);
        if (jsonInput == null || this.pointer == null) {
            return Long.MIN_VALUE;
        }
        long res = this.queryPointerValue(jsonInput);
        switch (this.stateA.simdJsonResult.getType()) {
            case 4: {
                assert (this.stateA.destUtf8Sink != null);
                try {
                    return IntervalUtils.parseFloorPartialTimestamp(this.stateA.destUtf8Sink.asAsciiCharSequence());
                }
                catch (NumericException e) {
                    return Long.MIN_VALUE;
                }
            }
            case 3: {
                return this.extractLongFromJsonNumber(res);
            }
        }
        return Long.MIN_VALUE;
    }

    @Override
    public final int getType() {
        return this.targetType;
    }

    @Override
    @Nullable
    public DirectUtf8Sink getVarcharA(Record rec) {
        return this.extractVarchar(this.json.getVarcharA(rec), this.stateA);
    }

    @Override
    @Nullable
    public DirectUtf8Sink getVarcharB(Record rec) {
        assert (this.stateB != null);
        return this.extractVarchar(this.json.getVarcharB(rec), this.stateB);
    }

    @Override
    public int getVarcharSize(Record rec) {
        DirectUtf8Sink utf8seq = this.getVarcharA(rec);
        if (utf8seq == null) {
            return -1;
        }
        return utf8seq.size();
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.stateA.reopen();
        if (this.stateB != null) {
            this.stateB.reopen();
        }
        this.json.init(symbolTableSource, executionContext);
        this.path.init(symbolTableSource, executionContext);
        this.pointer = Misc.free(this.pointer);
        this.pointer = JsonExtractSupportingState.varcharConstantToJsonPointer(this.path);
    }

    @Override
    public boolean isRuntimeConstant() {
        return this.pointer == null;
    }

    private long extractLongFromJsonNumber(long res) {
        switch (this.stateA.simdJsonResult.getNumberType()) {
            case 2: {
                return res;
            }
            case 1: {
                double d = Double.longBitsToDouble(res);
                if (!(d >= -9.223372036854776E18) || !(d <= 9.223372036854776E18)) break;
                return (long)d;
            }
        }
        return Long.MIN_VALUE;
    }

    @Nullable
    private DirectUtf8Sink extractVarchar(Utf8Sequence json, JsonExtractSupportingState state) {
        if (json != null && this.pointer != null) {
            assert (state.destUtf8Sink != null);
            state.destUtf8Sink.clear();
            state.parser.queryPointerUtf8(state.initPaddedJson(json), this.pointer, state.simdJsonResult, state.destUtf8Sink, this.maxSize);
            if (state.simdJsonResult.hasValue()) {
                return state.destUtf8Sink;
            }
        }
        return null;
    }

    private long queryPointerValue(Utf8Sequence jsonInput) {
        assert (this.stateA.destUtf8Sink != null);
        this.stateA.destUtf8Sink.clear();
        return this.stateA.parser.queryPointerValue(this.stateA.initPaddedJson(jsonInput), this.pointer, this.stateA.simdJsonResult, this.stateA.destUtf8Sink, this.maxSize);
    }
}

