/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SignIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "sign(I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.get(0));
    }

    static class Func
    extends IntFunction
    implements UnaryFunction {
        private final Function arg;

        Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getInt(Record rec) {
            int val = this.arg.getInt(rec);
            if (val == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return Integer.signum(val);
        }

        @Override
        public String getName() {
            return "sign";
        }
    }
}

