/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;

public class ConcatFunctionFactory
implements FunctionFactory {
    private static final ObjList<TypeAdapter> adapterReferences = new ObjList();

    @Override
    public String getSignature() {
        return "concat(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args == null || args.size() == 0) {
            throw SqlException.$(position, "no arguments provided");
        }
        int n = args.size();
        boolean allConst = true;
        for (int i = 0; i < n; ++i) {
            Function func = args.getQuick(i);
            if (func.isConstant()) continue;
            allConst = false;
        }
        if (allConst) {
            return new ConstConcatFunction(new ObjList<Function>(args), argPositions);
        }
        IntList positions = new IntList();
        positions.addAll(argPositions);
        return new ConcatFunction(new ObjList<Function>(args), positions);
    }

    private static void populateAdapters(ObjList<TypeAdapter> adapters, ObjList<Function> functions, IntList argPositions) throws SqlException {
        int functionCount = functions.size();
        for (int i = 0; i < functionCount; ++i) {
            int type = functions.getQuick(i).getType();
            short tag = ColumnType.tagOf(type);
            TypeAdapter adapter = adapterReferences.getQuick(tag);
            if (adapter == null) {
                throw SqlException.position(argPositions.getQuick(i)).put("unsupported type: ").put(ColumnType.nameOf(type));
            }
            adapters.add(adapter);
        }
    }

    private static void sinkBin(Utf16Sink sink, Function function, Record record) {
        sink.put('[');
        sink.put(']');
    }

    private static void sinkBool(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getBool(record));
    }

    private static void sinkByte(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getByte(record));
    }

    private static void sinkChar(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getChar(record));
    }

    private static void sinkDate(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getDate(record));
    }

    private static void sinkDouble(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getDouble(record));
    }

    private static void sinkFloat(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getFloat(record));
    }

    private static void sinkIPv4(Utf16Sink utf16Sink, Function function, Record record) {
        Numbers.intToIPv4Sink(utf16Sink, function.getIPv4(record));
    }

    private static void sinkInt(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getInt(record));
    }

    private static void sinkLong(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getLong(record));
    }

    private static void sinkLong256(Utf16Sink sink, Function function, Record record) {
        function.getLong256(record, sink);
    }

    private static void sinkNull(Utf16Sink sink, Function function, Record record) {
    }

    private static void sinkShort(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getShort(record));
    }

    private static void sinkStr(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getStrA(record));
    }

    private static void sinkSymbol(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getSymbol(record));
    }

    private static void sinkTimestamp(Utf16Sink sink, Function function, Record record) {
        sink.put(function.getTimestamp(record));
    }

    private static void sinkUuid(Utf16Sink sink, Function function, Record record) {
        long lo = function.getLong128Lo(record);
        long hi = function.getLong128Hi(record);
        SqlUtil.implicitCastUuidAsStr(lo, hi, sink);
    }

    private static void sinkVarchar(Utf16Sink utf16Sink, Function function, Record record) {
        utf16Sink.put(function.getStrA(record));
    }

    static {
        adapterReferences.extendAndSet(13, ConcatFunctionFactory::sinkLong256);
        adapterReferences.extendAndSet(1, ConcatFunctionFactory::sinkBool);
        adapterReferences.extendAndSet(2, ConcatFunctionFactory::sinkByte);
        adapterReferences.extendAndSet(3, ConcatFunctionFactory::sinkShort);
        adapterReferences.extendAndSet(4, ConcatFunctionFactory::sinkChar);
        adapterReferences.extendAndSet(5, ConcatFunctionFactory::sinkInt);
        adapterReferences.extendAndSet(25, ConcatFunctionFactory::sinkIPv4);
        adapterReferences.extendAndSet(6, ConcatFunctionFactory::sinkLong);
        adapterReferences.extendAndSet(9, ConcatFunctionFactory::sinkFloat);
        adapterReferences.extendAndSet(10, ConcatFunctionFactory::sinkDouble);
        adapterReferences.extendAndSet(11, ConcatFunctionFactory::sinkStr);
        adapterReferences.extendAndSet(26, ConcatFunctionFactory::sinkVarchar);
        adapterReferences.extendAndSet(12, ConcatFunctionFactory::sinkSymbol);
        adapterReferences.extendAndSet(18, ConcatFunctionFactory::sinkBin);
        adapterReferences.extendAndSet(7, ConcatFunctionFactory::sinkDate);
        adapterReferences.extendAndSet(8, ConcatFunctionFactory::sinkTimestamp);
        adapterReferences.extendAndSet(19, ConcatFunctionFactory::sinkUuid);
        adapterReferences.extendAndSet(33, ConcatFunctionFactory::sinkNull);
    }

    private static class ConstConcatFunction
    extends StrFunction
    implements ConstantFunction {
        private final ObjList<Function> functions;
        private final StringSink sink = new StringSink();

        public ConstConcatFunction(ObjList<Function> functions, IntList argPositions) throws SqlException {
            this.functions = functions;
            int functionCount = functions.size();
            ObjList<TypeAdapter> adapters = new ObjList<TypeAdapter>(functionCount);
            ConcatFunctionFactory.populateAdapters(adapters, functions, argPositions);
            for (int i = 0; i < functionCount; ++i) {
                adapters.getQuick(i).sink(this.sink, functions.getQuick(i), null);
            }
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.sink;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.sink;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("concat(").val(this.functions).val(')');
        }
    }

    private static class ConcatFunction
    extends StrFunction
    implements MultiArgFunction {
        private final ObjList<TypeAdapter> adapters;
        private final IntList argPositions;
        private final int functionCount;
        private final ObjList<Function> functions;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public ConcatFunction(ObjList<Function> functions, IntList argPositions) {
            this.functions = functions;
            this.functionCount = functions.size();
            this.argPositions = argPositions;
            this.adapters = new ObjList(this.functionCount);
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.functions;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            this.sinkA.clear();
            this.getStr(rec, this.sinkA);
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            this.sinkB.clear();
            this.getStr(rec, this.sinkB);
            return this.sinkB;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            MultiArgFunction.super.init(symbolTableSource, executionContext);
            ConcatFunctionFactory.populateAdapters(this.adapters, this.functions, this.argPositions);
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("concat(").val(this.functions).val(')');
        }

        private void getStr(Record rec, Utf16Sink utf16Sink) {
            for (int i = 0; i < this.functionCount; ++i) {
                this.adapters.getQuick(i).sink(utf16Sink, this.functions.getQuick(i), rec);
            }
        }
    }

    @FunctionalInterface
    private static interface TypeAdapter {
        public void sink(Utf16Sink var1, Function var2, Record var3);
    }
}

