/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.BasePartitionedWindowFunction;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.griffin.engine.functions.window.WindowLongFunction;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class CountFunctionFactoryHelper {
    public static final ArrayColumnTypes COUNT_COLUMN_TYPES = new ArrayColumnTypes();
    public static final ArrayColumnTypes COUNT_OVER_PARTITION_RANGE_COLUMN_TYPES;
    public static final ArrayColumnTypes COUNT_OVER_PARTITION_ROWS_COLUMN_TYPES;
    static final String COUNT_NAME = "count";

    static Function newCountWindowFunction(AbstractWindowFunctionFactory factory, int position, ObjList<Function> args, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext, IsRecordNotNull isRecordNotNull) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        windowContext.validate(position, factory.supportNullsDesc());
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        if (rowsHi < rowsLo) {
            return new AbstractWindowFunctionFactory.LongNullFunction(args.get(0), COUNT_NAME, rowsLo, rowsHi, framingMode == 1, partitionByRecord, 0L);
        }
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, COUNT_COLUMN_TYPES);
                    return new CountOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0), isRecordNotNull);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, COUNT_COLUMN_TYPES);
                    return new CountOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0), isRecordNotNull);
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                Map map = null;
                MemoryCARW mem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, COUNT_OVER_PARTITION_RANGE_COLUMN_TYPES);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    return new CountOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, mem, configuration.getSqlWindowInitialRangeBufferSize(), timestampIndex, args.get(0), isRecordNotNull);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    throw th;
                }
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, COUNT_COLUMN_TYPES);
                    return new CountOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0), isRecordNotNull);
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new CountOverCurrentRowFunction(args.get(0), isRecordNotNull);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, COUNT_COLUMN_TYPES);
                    return new CountOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0), isRecordNotNull);
                }
                Map map = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, COUNT_OVER_PARTITION_ROWS_COLUMN_TYPES);
                    MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    return new CountOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, isRecordNotNull);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    throw th;
                }
            }
        } else {
            if (framingMode == 1) {
                if (!windowContext.isOrdered() && windowContext.isDefaultFrame()) {
                    return new CountOverWholeResultSetFunction(args.get(0), isRecordNotNull);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new CountOverUnboundedRowsFrameFunction(args.get(0), isRecordNotNull);
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                return new CountOverRangeFrameFunction(rowsLo, rowsHi, configuration, timestampIndex, args.get(0), isRecordNotNull);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new CountOverUnboundedRowsFrameFunction(args.get(0), isRecordNotNull);
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new CountOverCurrentRowFunction(args.get(0), isRecordNotNull);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    return new CountOverWholeResultSetFunction(args.get(0), isRecordNotNull);
                }
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new CountOverRowsFrameFunction(args.get(0), rowsLo, rowsHi, mem, isRecordNotNull);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }

    static {
        COUNT_COLUMN_TYPES.add(6);
        COUNT_OVER_PARTITION_RANGE_COLUMN_TYPES = new ArrayColumnTypes();
        COUNT_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        COUNT_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        COUNT_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        COUNT_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        COUNT_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        COUNT_OVER_PARTITION_ROWS_COLUMN_TYPES = new ArrayColumnTypes();
        COUNT_OVER_PARTITION_ROWS_COLUMN_TYPES.add(6);
        COUNT_OVER_PARTITION_ROWS_COLUMN_TYPES.add(6);
        COUNT_OVER_PARTITION_ROWS_COLUMN_TYPES.add(6);
    }

    static class CountOverPartitionFunction
    extends BasePartitionedWindowFunction
    implements WindowLongFunction {
        private final IsRecordNotNull isNotNullFunc;

        public CountOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg, IsRecordNotNull isNotNullFunc) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.isNotNullFunc = isNotNullFunc;
        }

        @Override
        public String getName() {
            return CountFunctionFactoryHelper.COUNT_NAME;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            long count = 0L;
            if (!value.isNew()) {
                count = value.getLong(0);
            }
            if (this.isNotNullFunc.isNotNull(this.arg, record)) {
                ++count;
            }
            value.putLong(0, count);
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.findValue();
            long val = value != null ? value.getLong(0) : 0L;
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), val);
        }
    }

    @FunctionalInterface
    public static interface IsRecordNotNull {
        public boolean isNotNull(Function var1, Record var2);
    }

    static class CountOverUnboundedPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowLongFunction {
        private final IsRecordNotNull isRecordNotNull;
        private long count;

        public CountOverUnboundedPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg, IsRecordNotNull isRecordNotNull) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.isRecordNotNull = isRecordNotNull;
        }

        @Override
        public void computeNext(Record record) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            long count = 0L;
            if (!value.isNew()) {
                count = value.getLong(0);
            }
            if (this.isRecordNotNull.isNotNull(this.arg, record)) {
                ++count;
            }
            this.count = count;
            value.putLong(0, count);
        }

        @Override
        public long getLong(Record rec) {
            return this.count;
        }

        @Override
        public String getName() {
            return CountFunctionFactoryHelper.COUNT_NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.count);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            if (this.arg != null) {
                sink.val('(').val(this.arg).val(')');
            } else {
                sink.val("(*)");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between unbounded preceding and current row)");
        }
    }

    public static class CountOverPartitionRangeFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowLongFunction {
        private static final int RECORD_SIZE = 8;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final LongList freeList = new LongList();
        private final int initialBufferSize;
        private final IsRecordNotNull isNotNullFunc;
        private final long maxDiff;
        private final MemoryARW memory;
        private final AbstractWindowFunctionFactory.RingBufferDesc memoryDesc = new AbstractWindowFunctionFactory.RingBufferDesc();
        private final long minDiff;
        private final int timestampIndex;
        private long count;

        public CountOverPartitionRangeFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rangeLo, long rangeHi, MemoryARW memory, int initialBufferSize, int timestampIdx, Function arg, IsRecordNotNull isNotNullFunc) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Long.MAX_VALUE;
            this.minDiff = Math.abs(rangeHi);
            this.memory = memory;
            this.initialBufferSize = initialBufferSize;
            this.timestampIndex = timestampIdx;
            this.frameIncludesCurrentValue = rangeHi == 0L;
            this.isNotNullFunc = isNotNullFunc;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
            this.freeList.clear();
        }

        @Override
        public void computeNext(Record record) {
            long size;
            long frameSize;
            long firstIdx;
            long startOffset;
            long capacity;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            long timestamp = record.getTimestamp(this.timestampIndex);
            if (mapValue.isNew()) {
                capacity = this.initialBufferSize;
                startOffset = this.memory.appendAddressFor(capacity * 8L) - this.memory.getPageAddress(0);
                firstIdx = 0L;
                if (this.isNotNullFunc.isNotNull(this.arg, record)) {
                    this.memory.putLong(startOffset, timestamp);
                    if (this.frameIncludesCurrentValue) {
                        frameSize = 1L;
                        size = this.frameLoBounded ? 1L : 0L;
                    } else {
                        frameSize = 0L;
                        size = 1L;
                    }
                } else {
                    size = 0L;
                    frameSize = 0L;
                }
            } else {
                long idx;
                long ts;
                long i;
                long n;
                frameSize = mapValue.getLong(0);
                startOffset = mapValue.getLong(1);
                size = mapValue.getLong(2);
                capacity = mapValue.getLong(3);
                long newFirstIdx = firstIdx = mapValue.getLong(4);
                if (this.frameLoBounded) {
                    n = size;
                    for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 8L))) > this.maxDiff; ++i) {
                        if (frameSize > 0L) {
                            --frameSize;
                        }
                        newFirstIdx = (idx + 1L) % capacity;
                        --size;
                    }
                }
                firstIdx = newFirstIdx;
                if (this.isNotNullFunc.isNotNull(this.arg, record)) {
                    if (size == capacity) {
                        this.memoryDesc.reset(capacity, startOffset, size, firstIdx, this.freeList);
                        AbstractWindowFunctionFactory.expandRingBuffer(this.memory, this.memoryDesc, 8);
                        capacity = this.memoryDesc.capacity;
                        startOffset = this.memoryDesc.startOffset;
                        firstIdx = this.memoryDesc.firstIdx;
                    }
                    this.memory.putLong(startOffset + (firstIdx + size) % capacity * 8L, timestamp);
                    ++size;
                }
                if (this.frameLoBounded) {
                    long idx2;
                    long ts2;
                    long diff;
                    for (i = frameSize; i < size && (diff = Math.abs((ts2 = this.memory.getLong(startOffset + (idx2 = (firstIdx + i) % capacity) * 8L)) - timestamp)) <= this.maxDiff && diff >= this.minDiff; ++i) {
                        ++frameSize;
                    }
                } else {
                    newFirstIdx = firstIdx;
                    n = size;
                    for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 8L))) >= this.minDiff; ++i) {
                        ++frameSize;
                        newFirstIdx = (idx + 1L) % capacity;
                        --size;
                    }
                    firstIdx = newFirstIdx;
                }
            }
            this.count = frameSize;
            mapValue.putLong(0, frameSize);
            mapValue.putLong(1, startOffset);
            mapValue.putLong(2, size);
            mapValue.putLong(3, capacity);
            mapValue.putLong(4, firstIdx);
        }

        @Override
        public long getLong(Record rec) {
            return this.count;
        }

        @Override
        public String getName() {
            return CountFunctionFactoryHelper.COUNT_NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            super.reopen();
            this.count = 0L;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
            this.freeList.clear();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            if (this.arg != null) {
                sink.val('(').val(this.arg).val(')');
            } else {
                sink.val("(*)");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" range between ");
            if (this.frameLoBounded) {
                sink.val(this.maxDiff);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.minDiff == 0L) {
                sink.val("current row");
            } else {
                sink.val(this.minDiff).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
            this.freeList.clear();
        }
    }

    static class CountOverCurrentRowFunction
    extends BaseWindowFunction
    implements WindowLongFunction {
        private static final long VALUE_ONE = 1L;
        private static final long VALUE_ZERO = 0L;
        private final IsRecordNotNull isNotNullFunc;
        private long value;

        CountOverCurrentRowFunction(Function arg, IsRecordNotNull isNotNullFunc) {
            super(arg);
            this.isNotNullFunc = isNotNullFunc;
        }

        @Override
        public long getLong(Record rec) {
            this.value = this.isNotNullFunc.isNotNull(this.arg, rec) ? 1L : 0L;
            return this.value;
        }

        @Override
        public String getName() {
            return CountFunctionFactoryHelper.COUNT_NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }
    }

    public static class CountOverPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowLongFunction {
        private final int bufferSize;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final int frameSize;
        private final IsRecordNotNull isRecordNotNull;
        private final MemoryARW memory;
        protected long count;

        public CountOverPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rowsLo, long rowsHi, Function arg, MemoryARW memory, IsRecordNotNull isRecordNotNull) {
            super(map, partitionByRecord, partitionBySink, arg);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
            } else {
                this.frameSize = 1;
                this.bufferSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.memory = memory;
            this.isRecordNotNull = isRecordNotNull;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
        }

        @Override
        public void computeNext(Record record) {
            long startOffset;
            long loIdx;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            long count = 0L;
            boolean isNotNull = this.isRecordNotNull.isNotNull(this.arg, record);
            if (value.isNew()) {
                loIdx = 0L;
                startOffset = this.memory.appendAddressFor(this.bufferSize) - this.memory.getPageAddress(0);
                if (this.frameIncludesCurrentValue && isNotNull) {
                    count = 1L;
                }
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.memory.putBool(startOffset + (long)i, false);
                }
                this.count = count;
            } else {
                count = value.getLong(0);
                loIdx = value.getLong(1);
                startOffset = value.getLong(2);
                if (this.frameIncludesCurrentValue ? isNotNull : this.memory.getBool(startOffset + (loIdx + (long)this.frameSize - 1L) % (long)this.bufferSize)) {
                    ++count;
                }
                this.count = count--;
                if (!this.frameLoBounded || this.memory.getBool(startOffset + loIdx)) {
                    // empty if block
                }
            }
            value.putLong(0, count);
            value.putLong(1, (loIdx + 1L) % (long)this.bufferSize);
            value.putLong(2, startOffset);
            this.memory.putBool(startOffset + loIdx, isNotNull);
        }

        @Override
        public long getLong(Record rec) {
            return this.count;
        }

        @Override
        public String getName() {
            return CountFunctionFactoryHelper.COUNT_NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.count);
        }

        @Override
        public void reopen() {
            super.reopen();
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            if (this.arg != null) {
                sink.val('(').val(this.arg).val(')');
            } else {
                sink.val("*");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between ");
            if (this.frameLoBounded) {
                sink.val(this.bufferSize);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
        }
    }

    static class CountOverWholeResultSetFunction
    extends BaseWindowFunction
    implements WindowLongFunction {
        private final IsRecordNotNull isRecordNotNull;
        private long count;

        public CountOverWholeResultSetFunction(Function arg, IsRecordNotNull isRecordNotNull) {
            super(arg);
            this.isRecordNotNull = isRecordNotNull;
        }

        @Override
        public String getName() {
            return CountFunctionFactoryHelper.COUNT_NAME;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            if (this.isRecordNotNull.isNotNull(this.arg, record)) {
                ++this.count;
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.count);
        }

        @Override
        public void reset() {
            super.reset();
            this.count = 0L;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.count = 0L;
        }
    }

    public static class CountOverUnboundedRowsFrameFunction
    extends BaseWindowFunction
    implements WindowLongFunction {
        private final IsRecordNotNull isRecordNotNull;
        private long count = 0L;

        public CountOverUnboundedRowsFrameFunction(Function arg, IsRecordNotNull isRecordNotNull) {
            super(arg);
            this.isRecordNotNull = isRecordNotNull;
        }

        @Override
        public void computeNext(Record record) {
            if (this.isRecordNotNull.isNotNull(this.arg, record)) {
                ++this.count;
            }
        }

        @Override
        public long getLong(Record rec) {
            return this.count;
        }

        @Override
        public String getName() {
            return CountFunctionFactoryHelper.COUNT_NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.count);
        }

        @Override
        public void reset() {
            super.reset();
            this.count = 0L;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            if (this.arg != null) {
                sink.val('(').val(this.arg).val(')');
            } else {
                sink.val("(*)");
            }
            sink.val(" over (rows between unbounded preceding and current row)");
        }

        @Override
        public void toTop() {
            super.toTop();
            this.count = 0L;
        }
    }

    public static class CountOverRangeFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowLongFunction {
        private static final int RECORD_SIZE = 8;
        private final boolean frameLoBounded;
        private final long initialCapacity;
        private final IsRecordNotNull isRecordNotNull;
        private final long maxDiff;
        private final MemoryARW memory;
        private final long minDiff;
        private final int timestampIndex;
        private long capacity;
        private long count;
        private long firstIdx;
        private long size;
        private long startOffset;

        public CountOverRangeFrameFunction(long rangeLo, long rangeHi, CairoConfiguration configuration, int timestampIdx, Function arg, IsRecordNotNull isRecordNotNull) {
            super(arg);
            this.initialCapacity = configuration.getSqlWindowStorePageSize() / 8;
            this.memory = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
            this.isRecordNotNull = isRecordNotNull;
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Long.MAX_VALUE;
            this.minDiff = Math.abs(rangeHi);
            this.timestampIndex = timestampIdx;
            this.capacity = this.initialCapacity;
            this.startOffset = this.memory.appendAddressFor(this.capacity * 8L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.count = 0L;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
        }

        @Override
        public void computeNext(Record record) {
            long idx;
            long ts;
            long i;
            long n;
            long timestamp = record.getTimestamp(this.timestampIndex);
            boolean isNotNull = this.isRecordNotNull.isNotNull(this.arg, record);
            long newFirstIdx = this.firstIdx;
            if (this.frameLoBounded) {
                n = this.size;
                for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 8L))) > this.maxDiff; ++i) {
                    if (this.count > 0L) {
                        --this.count;
                    }
                    newFirstIdx = (idx + 1L) % this.capacity;
                    --this.size;
                }
            }
            this.firstIdx = newFirstIdx;
            if (isNotNull) {
                if (this.size == this.capacity) {
                    long newAddress = this.memory.appendAddressFor((this.capacity << 1) * 8L);
                    long oldAddress = this.memory.getPageAddress(0) + this.startOffset;
                    if (this.firstIdx == 0L) {
                        Vect.memcpy(newAddress, oldAddress, this.size * 8L);
                    } else {
                        this.firstIdx %= this.size;
                        long firstPieceSize = (this.size - this.firstIdx) * 8L;
                        Vect.memcpy(newAddress, oldAddress + this.firstIdx * 8L, firstPieceSize);
                        Vect.memcpy(newAddress + firstPieceSize, oldAddress, this.firstIdx * 8L);
                        this.firstIdx = 0L;
                    }
                    this.startOffset = newAddress - this.memory.getPageAddress(0);
                    this.capacity <<= 1;
                }
                this.memory.putLong(this.startOffset + (this.firstIdx + this.size) % this.capacity * 8L, timestamp);
                ++this.size;
            }
            if (this.frameLoBounded) {
                long diff;
                n = this.size;
                for (i = this.count; i < n && (diff = Math.abs((ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 8L)) - timestamp)) <= this.maxDiff && diff >= this.minDiff; ++i) {
                    ++this.count;
                }
            } else {
                newFirstIdx = this.firstIdx;
                n = this.size;
                for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 8L))) >= this.minDiff; ++i) {
                    ++this.count;
                    newFirstIdx = (idx + 1L) % this.capacity;
                    --this.size;
                }
                this.firstIdx = newFirstIdx;
            }
        }

        @Override
        public long getLong(Record rec) {
            return this.count;
        }

        @Override
        public String getName() {
            return CountFunctionFactoryHelper.COUNT_NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            this.count = 0L;
            this.capacity = this.initialCapacity;
            this.startOffset = this.memory.appendAddressFor(this.capacity * 8L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.size = 0L;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("range between ");
            if (this.frameLoBounded) {
                sink.val(this.maxDiff);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.minDiff == 0L) {
                sink.val("current row");
            } else {
                sink.val(this.minDiff).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            this.capacity = this.initialCapacity;
            this.memory.truncate();
            this.startOffset = this.memory.appendAddressFor(this.capacity * 8L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.count = 0L;
            this.size = 0L;
        }
    }

    public static class CountOverRowsFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowLongFunction {
        private final MemoryARW buffer;
        private final int bufferSize;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final int frameSize;
        private final IsRecordNotNull isRecordNotNull;
        private long count = 0L;
        private long lastcount = 0L;
        private int loIdx = 0;

        public CountOverRowsFrameFunction(Function arg, long rowsLo, long rowsHi, MemoryARW memory, IsRecordNotNull isRecordNotNull) {
            super(arg);
            assert (rowsLo != Long.MIN_VALUE || rowsHi != 0L);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
            } else {
                this.bufferSize = this.frameSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.buffer = memory;
            this.isRecordNotNull = isRecordNotNull;
            try {
                this.initBuffer();
            }
            catch (Throwable t) {
                this.close();
                throw t;
            }
        }

        @Override
        public void close() {
            super.close();
            this.buffer.close();
        }

        @Override
        public void computeNext(Record record) {
            boolean originIsNotNull;
            boolean isNotNull = originIsNotNull = this.isRecordNotNull.isNotNull(this.arg, record);
            if (this.frameLoBounded && !this.frameIncludesCurrentValue) {
                isNotNull = this.buffer.getBool((this.loIdx + this.frameSize - 1) % this.bufferSize);
            } else if (!this.frameLoBounded && !this.frameIncludesCurrentValue) {
                isNotNull = this.buffer.getBool(this.loIdx % this.bufferSize);
            }
            if (isNotNull) {
                ++this.lastcount;
            }
            this.count = this.lastcount--;
            if (!this.frameLoBounded || this.buffer.getBool(this.loIdx % this.bufferSize)) {
                // empty if block
            }
            this.buffer.putBool(this.loIdx, originIsNotNull);
            this.loIdx = (this.loIdx + 1) % this.bufferSize;
        }

        @Override
        public long getLong(Record rec) {
            return this.count;
        }

        @Override
        public String getName() {
            return CountFunctionFactoryHelper.COUNT_NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.count);
        }

        @Override
        public void reopen() {
            this.count = 0L;
            this.lastcount = 0L;
            this.loIdx = 0;
            this.initBuffer();
        }

        @Override
        public void reset() {
            super.reset();
            this.buffer.close();
            this.count = 0L;
            this.lastcount = 0L;
            this.loIdx = 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            if (this.arg != null) {
                sink.val('(').val(this.arg).val(')');
            } else {
                sink.val("(*)");
            }
            sink.val(" over (");
            sink.val(" rows between ");
            if (this.frameLoBounded) {
                sink.val(this.bufferSize);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.count = 0L;
            this.loIdx = 0;
            this.lastcount = 0L;
            this.initBuffer();
        }

        private void initBuffer() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer.putBool(i, false);
            }
        }
    }
}

