/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupByCharSink
implements Utf16Sink,
CharSequence,
Mutable {
    private static final long HEADER_SIZE = 8L;
    private static final long LEN_OFFSET = 4L;
    private static final int MIN_CAPACITY = 8;
    private GroupByAllocator allocator;
    private long ptr;

    public int capacity() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr) : 0;
    }

    @Override
    public char charAt(int index) {
        return Unsafe.getUnsafe().getChar(this.ptr + 8L + 2L * (long)index);
    }

    @Override
    public void clear() {
        if (this.ptr != 0L) {
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
        }
    }

    @Override
    public int length() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 4L) : 0;
    }

    public GroupByCharSink of(long ptr) {
        this.ptr = ptr;
        return this;
    }

    public long ptr() {
        return this.ptr;
    }

    @Override
    public GroupByCharSink put(@Nullable Utf8Sequence us) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GroupByCharSink put(@Nullable CharSequence cs) {
        if (cs != null) {
            int thatLen = cs.length();
            this.checkCapacity(thatLen);
            int thisLen = this.length();
            long lo = this.ptr + 8L + 2L * (long)thisLen;
            for (int i = 0; i < thatLen; ++i) {
                Unsafe.getUnsafe().putChar(lo + 2L * (long)i, cs.charAt(i));
            }
            Unsafe.getUnsafe().putInt(this.ptr + 4L, thisLen + thatLen);
        }
        return this;
    }

    @Override
    public GroupByCharSink put(char c) {
        this.checkCapacity(1);
        int len = this.length();
        long lo = this.ptr + 8L + 2L * (long)len;
        Unsafe.getUnsafe().putChar(lo, c);
        Unsafe.getUnsafe().putInt(this.ptr + 4L, len + 1);
        return this;
    }

    @Override
    public GroupByCharSink putAscii(char c) {
        return this.put(c);
    }

    @Override
    public GroupByCharSink putAscii(@Nullable CharSequence cs) {
        return this.put(cs);
    }

    @Override
    public GroupByCharSink putNonAscii(long lo, long hi) {
        throw new UnsupportedOperationException();
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String toString() {
        return AbstractCharSequence.getString(this);
    }

    private void checkCapacity(int nChars) {
        int newCapacity;
        int capacity = this.capacity();
        int len = this.length();
        int requiredCapacity = len + nChars;
        if (capacity > 0 && requiredCapacity <= capacity) {
            return;
        }
        for (newCapacity = Math.max(capacity, 8); newCapacity < requiredCapacity; newCapacity *= 2) {
        }
        long newSize = ((long)newCapacity << 1) + 8L;
        if (this.ptr == 0L) {
            this.ptr = this.allocator.malloc(newSize);
            Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
        } else {
            this.ptr = this.allocator.realloc(this.ptr, ((long)capacity << 1) + 8L, newSize);
            Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
        }
    }
}

