/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class YearTimestampSampler
implements TimestampSampler {
    private final int stepYears;
    private int startDay;
    private int startHour;
    private int startMicros;
    private int startMillis;
    private int startMin;
    private int startMonth;
    private int startSec;

    public YearTimestampSampler(int stepYears) {
        this.stepYears = stepYears;
    }

    @Override
    public long getApproxBucketSize() {
        return 31536000000000L * (long)this.stepYears;
    }

    @Override
    public long nextTimestamp(long timestamp) {
        return this.addYears(timestamp, this.stepYears);
    }

    @Override
    public long nextTimestamp(long timestamp, int numSteps) {
        return this.addYears(timestamp, numSteps * this.stepYears);
    }

    @Override
    public long previousTimestamp(long timestamp) {
        return this.addYears(timestamp, -this.stepYears);
    }

    @Override
    public long round(long value) {
        int y = Timestamps.getYear(value);
        y -= y % this.stepYears;
        return Timestamps.toMicros(y, Timestamps.isLeapYear(y), this.startDay, this.startMonth, this.startHour, this.startMin, this.startSec, this.startMillis, this.startMicros);
    }

    @Override
    public void setStart(long timestamp) {
        int y = Timestamps.getYear(timestamp);
        boolean leap = Timestamps.isLeapYear(y);
        this.startMonth = Timestamps.getMonthOfYear(timestamp, y, leap);
        this.startDay = Timestamps.getDayOfMonth(timestamp, y, this.startMonth, leap);
        this.startHour = Timestamps.getHourOfDay(timestamp);
        this.startMin = Timestamps.getMinuteOfHour(timestamp);
        this.startSec = Timestamps.getSecondOfMinute(timestamp);
        this.startMillis = Timestamps.getMillisOfSecond(timestamp);
        this.startMicros = Timestamps.getMicrosOfMilli(timestamp);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii("YearTsSampler");
    }

    private long addYears(long timestamp, int numYears) {
        if (numYears == 0) {
            return timestamp;
        }
        int y = Timestamps.getYear(timestamp);
        boolean leap = Timestamps.isLeapYear(y + numYears);
        int maxDay = Math.min(this.startDay, Timestamps.getDaysPerMonth(this.startMonth, leap)) - 1;
        return Timestamps.yearMicros(y + numYears, leap) + Timestamps.monthOfYearMicros(this.startMonth, leap) + (long)maxDay * 86400000000L + (long)this.startHour * 3600000000L + (long)this.startMin * 60000000L + (long)this.startSec * 1000000L + (long)this.startMillis * 1000L + (long)this.startMicros;
    }
}

