/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.LongBinaryOperator;

public class MinShortVectorAggregateFunction
extends IntFunction
implements VectorAggregateFunction {
    public static final LongBinaryOperator MIN = (l1, l2) -> {
        if (l1 == Integer.MIN_VALUE) {
            return l2;
        }
        if (l2 == Integer.MIN_VALUE) {
            return l1;
        }
        return Math.min(l1, l2);
    };
    private final LongAccumulator accumulator = new LongAccumulator(MIN, Integer.MIN_VALUE);
    private final int columnIndex;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private int valueOffset;

    public MinShortVectorAggregateFunction(int keyKind, int columnIndex, int workerCount) {
        this.columnIndex = columnIndex;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourMinShort;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntMinShort;
        }
    }

    @Override
    public void aggregate(long address, long frameRowCount, int workerId) {
        long value;
        if (address != 0L && (value = (long)Vect.minShort(address, frameRowCount)) != Integer.MIN_VALUE) {
            this.accumulator.accumulate(value);
        }
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long frameRowCount) {
        if (valueAddress == 0L) {
            return this.distinctFunc.run(pRosti, keyAddress, frameRowCount);
        }
        return this.keyValueFunc.run(pRosti, keyAddress, valueAddress, frameRowCount, this.valueOffset);
    }

    @Override
    public void clear() {
        this.accumulator.reset();
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getInt(Record rec) {
        return this.accumulator.intValue();
    }

    @Override
    public String getName() {
        return "min";
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset), Long.MIN_VALUE);
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntMinLongMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(6);
    }

    @Override
    public boolean wrapUp(long pRosti) {
        return Rosti.keyedIntMinShortWrapUp(pRosti, this.valueOffset, this.accumulator.intValue());
    }
}

