/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.mp.Sequence;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.Rosti;
import io.questdb.std.RostiAllocFacade;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VectorAggregateEntry
implements Mutable {
    private ExecutionCircuitBreaker circuitBreaker;
    private CountDownLatchSPI doneLatch;
    private int frameIndex;
    private ObjList<PageFrameMemoryPool> frameMemoryPools;
    private long frameRowCount;
    private VectorAggregateFunction func;
    private int keyColIndex;
    private AtomicInteger oomCounter;
    private long[] pRosti;
    private PerWorkerLocks perWorkerLocks;
    private RostiAllocFacade raf;
    private AtomicInteger startedCounter;
    private int valueColIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aggregateUnsafe(int workerId, @Nullable AtomicInteger oomCounter, int frameIndex, long frameRowCount, int keyColIndex, int valueColIndex, long @Nullable [] pRosti, @NotNull ObjList<PageFrameMemoryPool> frameMemoryPools, @Nullable RostiAllocFacade raf, @NotNull VectorAggregateFunction func, @NotNull PerWorkerLocks perWorkerLocks, @NotNull ExecutionCircuitBreaker circuitBreaker) {
        int slot = perWorkerLocks.acquireSlot(workerId, circuitBreaker);
        try {
            long keyAddress;
            PageFrameMemoryPool frameMemoryPool = frameMemoryPools.getQuick(slot);
            PageFrameMemory frameMemory = frameMemoryPool.navigateTo(frameIndex);
            long valueAddress = valueColIndex > -1 ? frameMemory.getPageAddress(valueColIndex) : 0L;
            long l = keyAddress = keyColIndex > -1 ? frameMemory.getPageAddress(keyColIndex) : 0L;
            if (pRosti != null && keyAddress != 0L) {
                long oldSize = Rosti.getAllocMemory(pRosti[slot]);
                if (!func.aggregate(pRosti[slot], keyAddress, valueAddress, frameRowCount) && oomCounter != null) {
                    oomCounter.incrementAndGet();
                }
                if (raf != null) {
                    raf.updateMemoryUsage(pRosti[slot], oldSize);
                }
            } else {
                func.aggregate(valueAddress, frameRowCount, slot);
            }
        }
        finally {
            perWorkerLocks.releaseSlot(slot);
        }
    }

    @Override
    public void clear() {
        this.frameMemoryPools = null;
        this.func = null;
        this.pRosti = null;
        this.startedCounter = null;
        this.doneLatch = null;
        this.oomCounter = null;
        this.raf = null;
        this.perWorkerLocks = null;
        this.circuitBreaker = null;
        this.frameRowCount = 0L;
        this.keyColIndex = -1;
        this.valueColIndex = -1;
    }

    public void run(int workerId, Sequence seq, long cursor) {
        AtomicInteger oomCounter = this.oomCounter;
        int frameIndex = this.frameIndex;
        long frameRowCount = this.frameRowCount;
        int keyColIndex = this.keyColIndex;
        int valueColIndex = this.valueColIndex;
        long[] pRosti = this.pRosti;
        ObjList<PageFrameMemoryPool> frameMemoryPools = this.frameMemoryPools;
        RostiAllocFacade raf = this.raf;
        VectorAggregateFunction func = this.func;
        ExecutionCircuitBreaker circuitBreaker = this.circuitBreaker;
        AtomicInteger startedCounter = this.startedCounter;
        CountDownLatchSPI doneLatch = this.doneLatch;
        PerWorkerLocks perWorkerLocks = this.perWorkerLocks;
        seq.done(cursor);
        VectorAggregateEntry.aggregate(workerId, oomCounter, frameIndex, frameRowCount, keyColIndex, valueColIndex, pRosti, frameMemoryPools, raf, func, perWorkerLocks, circuitBreaker, startedCounter, doneLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void aggregate(int workerId, AtomicInteger oomCounter, int frameIndex, long frameRowCount, int keyColIndex, int valueColIndex, long[] pRosti, ObjList<PageFrameMemoryPool> frameMemoryPools, RostiAllocFacade raf, VectorAggregateFunction func, PerWorkerLocks perWorkerLocks, ExecutionCircuitBreaker circuitBreaker, AtomicInteger startedCounter, CountDownLatchSPI doneLatch) {
        startedCounter.incrementAndGet();
        if (circuitBreaker.checkIfTripped() || oomCounter != null && oomCounter.get() > 0) {
            doneLatch.countDown();
            return;
        }
        try {
            VectorAggregateEntry.aggregateUnsafe(workerId, oomCounter, frameIndex, frameRowCount, keyColIndex, valueColIndex, pRosti, frameMemoryPools, raf, func, perWorkerLocks, circuitBreaker);
        }
        finally {
            doneLatch.countDown();
        }
    }

    void of(int frameIndex, long frameRowCount, int keyColIndex, int valueColIndex, @NotNull VectorAggregateFunction vaf, long @Nullable [] pRosti, @NotNull ObjList<PageFrameMemoryPool> frameMemoryPools, @NotNull AtomicInteger startedCounter, @NotNull CountDownLatchSPI doneLatch, @Nullable AtomicInteger oomCounter, @Nullable RostiAllocFacade raf, @NotNull PerWorkerLocks perWorkerLocks, @NotNull ExecutionCircuitBreaker circuitBreaker) {
        this.frameIndex = frameIndex;
        this.frameRowCount = frameRowCount;
        this.keyColIndex = keyColIndex;
        this.valueColIndex = valueColIndex;
        this.pRosti = pRosti;
        this.frameMemoryPools = frameMemoryPools;
        this.func = vaf;
        this.startedCounter = startedCounter;
        this.doneLatch = doneLatch;
        this.oomCounter = oomCounter;
        this.raf = raf;
        this.perWorkerLocks = perWorkerLocks;
        this.circuitBreaker = circuitBreaker;
    }
}

