/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.cairo.CairoException;
import io.questdb.log.LogError;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecordUtf8Sink;
import io.questdb.log.LogWriter;
import io.questdb.log.TemplateParser;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.DirectLongList;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.FindVisitor;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.DirectUtf16Sink;
import io.questdb.std.str.DirectUtf8StringZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;

public class LogRollingFileWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    public static final long DEFAULT_SPIN_BEFORE_FLUSH = 100000L;
    private static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private static final int INITIAL_LOG_FILE_LIST_SIZE = 1024;
    private static final int INITIAL_LOG_FILE_NAME_SINK_SIZE = 65536;
    private final MicrosecondClock clock;
    private final FilesFacade ff;
    private final int level;
    private final TemplateParser locationParser = new TemplateParser();
    private final DirectUtf8StringZ logFileName = new DirectUtf8StringZ();
    private final Path path;
    private final Path renameToPath;
    private final RingQueue<LogRecordUtf8Sink> ring;
    private final AtomicLong rolledCounter = new AtomicLong();
    private final SCSequence subSeq;
    private long _wptr;
    private long buf;
    private String bufferSize;
    private long currentSize;
    private long fd = -1L;
    private long idleSpinCount = 0L;
    private String lifeDuration;
    private long lim;
    private String location;
    private String logDir;
    private DirectLongList logFileList;
    private DirectUtf16Sink logFileNameSink;
    private String logFileTemplate;
    private final FindVisitor removeExcessiveLogsRef = this::removeExcessiveLogs;
    private int nBufferSize;
    private long nLifeDuration;
    private final FindVisitor removeExpiredLogsRef = this::removeExpiredLogs;
    private long nRollSize;
    private long nSizeLimit;
    private long nSpinBeforeFlush;
    private long rollDeadline;
    private NextDeadline rollDeadlineFunction;
    private String rollEvery;
    private String rollSize;
    private String sizeLimit;
    private final QueueConsumer<LogRecordUtf8Sink> copyToBufferRef = this::copyToBuffer;
    private String spinBeforeFlush;

    public LogRollingFileWriter(RingQueue<LogRecordUtf8Sink> ring, SCSequence subSeq, int level) {
        this(FilesFacadeImpl.INSTANCE, MicrosecondClockImpl.INSTANCE, ring, subSeq, level);
    }

    public LogRollingFileWriter(FilesFacade ff, MicrosecondClock clock, RingQueue<LogRecordUtf8Sink> ring, SCSequence subSeq, int level) {
        try {
            this.path = new Path();
            this.renameToPath = new Path();
            this.ff = ff;
            this.clock = clock;
            this.ring = ring;
            this.subSeq = subSeq;
            this.level = level;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void bindProperties(LogFactory factory) {
        if (this.location == null) {
            throw CairoException.nonCritical().put("rolling log file location not set [location=null]");
        }
        this.locationParser.parseEnv(this.location, this.clock.getTicks());
        if (this.bufferSize != null) {
            try {
                this.nBufferSize = Numbers.parseIntSize(this.bufferSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for bufferSize");
            }
        } else {
            this.nBufferSize = 0x400000;
        }
        if (this.rollSize != null) {
            try {
                this.nRollSize = Numbers.parseLongSize(this.rollSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for rollSize");
            }
        } else {
            this.nRollSize = Long.MAX_VALUE;
        }
        if (this.sizeLimit != null) {
            try {
                this.nSizeLimit = Numbers.parseLongSize(this.sizeLimit);
                if (this.nSizeLimit < this.nRollSize) {
                    throw new LogError("sizeLimit must be larger than rollSize");
                }
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for sizeLimit");
            }
        }
        if (this.lifeDuration != null) {
            try {
                this.nLifeDuration = Numbers.parseLongDuration(this.lifeDuration);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for lifeDuration");
            }
        }
        if (this.spinBeforeFlush != null) {
            try {
                this.nSpinBeforeFlush = Numbers.parseLong(this.spinBeforeFlush);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for spinBeforeFlush");
            }
        } else {
            this.nSpinBeforeFlush = 100000L;
        }
        if (this.rollEvery != null) {
            switch (this.rollEvery.trim().toUpperCase()) {
                case "DAY": {
                    this.rollDeadlineFunction = this::getNextDayDeadline;
                    break;
                }
                case "MONTH": {
                    this.rollDeadlineFunction = this::getNextMonthDeadline;
                    break;
                }
                case "YEAR": {
                    this.rollDeadlineFunction = this::getNextYearDeadline;
                    break;
                }
                case "HOUR": {
                    this.rollDeadlineFunction = this::getNextHourDeadline;
                    break;
                }
                case "MINUTE": {
                    this.rollDeadlineFunction = this::getNextMinuteDeadline;
                    break;
                }
                default: {
                    this.rollDeadlineFunction = this::getInfiniteDeadline;
                    break;
                }
            }
        } else {
            this.rollDeadlineFunction = this::getInfiniteDeadline;
        }
        this.rollDeadline = this.rollDeadlineFunction.getDeadline();
        this.buf = this._wptr = Unsafe.malloc(this.nBufferSize, 41);
        this.lim = this.buf + (long)this.nBufferSize;
        this.openFile();
        if (this.location.indexOf(36) < 0) {
            throw CairoException.nonCritical().put("rolling log file location does not contain `$` character [location=").put(this.location).put(']');
        }
        this.logFileTemplate = this.location.substring(this.path.toString().lastIndexOf(Files.SEPARATOR) + 1, this.location.lastIndexOf(36));
        this.logDir = this.location.substring(0, this.location.indexOf(this.logFileTemplate) - 1);
    }

    @Override
    public void close() {
        if (this.buf != 0L) {
            if (this._wptr > this.buf) {
                this.flush();
            }
            Unsafe.free(this.buf, this.nBufferSize, 41);
            this.buf = 0L;
        }
        if (this.ff.close(this.fd)) {
            this.fd = -1L;
        }
        Misc.free(this.path);
        Misc.free(this.renameToPath);
        Misc.free(this.logFileList);
        Misc.free(this.logFileNameSink);
    }

    public NextDeadline getRollDeadlineFunction() {
        return this.rollDeadlineFunction;
    }

    public long getRolledCount() {
        return this.rolledCounter.get();
    }

    @Override
    public boolean runSerially() {
        if (this.subSeq.consumeAll(this.ring, this.copyToBufferRef)) {
            return true;
        }
        if (++this.idleSpinCount > this.nSpinBeforeFlush && this._wptr > this.buf) {
            this.flush();
            this.idleSpinCount = 0L;
            return true;
        }
        return false;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setLifeDuration(String lifeDuration) {
        this.lifeDuration = lifeDuration;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setRollEvery(String rollEvery) {
        this.rollEvery = rollEvery;
    }

    public void setRollSize(String rollSize) {
        this.rollSize = rollSize;
    }

    public void setSizeLimit(String sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public void setSpinBeforeFlush(String spinBeforeFlush) {
        this.spinBeforeFlush = spinBeforeFlush;
    }

    private void buildFilePath(Path path) {
        path.of("");
        this.locationParser.toSink(path);
    }

    private void buildUniquePath() {
        this.buildFilePath(this.path);
        while (this.ff.exists(this.path.$())) {
            this.pushFileStackUp();
            this.buildFilePath(this.path);
        }
    }

    private void copyToBuffer(LogRecordUtf8Sink sink) {
        int size = sink.size();
        if ((sink.getLevel() & this.level) != 0 && size > 0) {
            if (this._wptr + (long)size >= this.lim) {
                this.flush();
            }
            Vect.memcpy(this._wptr, sink.ptr(), size);
            this._wptr += (long)size;
        }
    }

    private void flush() {
        int len;
        long ticks = Long.MIN_VALUE;
        if (this.currentSize > this.nRollSize || (ticks = this.clock.getTicks()) > this.rollDeadline) {
            this.ff.close(this.fd);
            this.removeOldLogs();
            if (ticks > this.rollDeadline) {
                this.rollDeadline = this.rollDeadlineFunction.getDeadline();
                this.locationParser.setDateValue(ticks);
            }
            this.openFile();
            this.rolledCounter.incrementAndGet();
        }
        if (this.ff.append(this.fd, this.buf, len = (int)(this._wptr - this.buf)) != (long)len) {
            throw new LogError("Could not append log [fd=" + this.fd + "]");
        }
        this.currentSize += (long)len;
        this._wptr = this.buf;
    }

    private long getInfiniteDeadline() {
        return Long.MAX_VALUE;
    }

    private long getNextDayDeadline() {
        return Timestamps.addDays(Timestamps.floorDD(this.clock.getTicks()), 1);
    }

    private long getNextHourDeadline() {
        return Timestamps.addHours(Timestamps.floorHH(this.clock.getTicks()), 1);
    }

    private long getNextMinuteDeadline() {
        return Timestamps.floorMI(this.clock.getTicks()) + 60000000L;
    }

    private long getNextMonthDeadline() {
        return Timestamps.addMonths(Timestamps.floorMM(this.clock.getTicks()), 1);
    }

    private long getNextYearDeadline() {
        return Timestamps.addYears(Timestamps.floorYYYY(this.clock.getTicks()), 1);
    }

    private void openFile() {
        this.buildUniquePath();
        this.fd = this.ff.openAppend(this.path.$());
        if (this.fd == -1L) {
            throw new LogError("[" + this.ff.errno() + "] Cannot open file for append: " + String.valueOf(this.path));
        }
        this.currentSize = this.ff.length(this.fd);
    }

    private void pushFileStackUp() {
        int index = 1;
        while (true) {
            this.buildFilePath(this.path);
            this.path.put('.').put(index);
            if (!this.ff.exists(this.path.$())) break;
            ++index;
        }
        while (index > 1) {
            this.buildFilePath(this.path);
            this.buildFilePath(this.renameToPath);
            this.path.put('.').put(index - 1);
            this.renameToPath.put('.').put(index);
            if (this.ff.rename(this.path.$(), this.renameToPath.$()) != 0) {
                throw new LogError("Could not rename " + String.valueOf(this.path) + " to " + String.valueOf(this.renameToPath));
            }
            --index;
        }
        this.buildFilePath(this.path);
        this.buildFilePath(this.renameToPath);
        this.renameToPath.put(".1");
        if (this.ff.rename(this.path.$(), this.renameToPath.$()) != 0) {
            throw new LogError("Could not rename " + String.valueOf(this.path) + " to " + String.valueOf(this.renameToPath));
        }
    }

    private void removeExcessiveLogs() {
        long lastIndex;
        this.path.of(this.logDir);
        long totalSize = 0L;
        for (long i = lastIndex = this.logFileList.size() - 2L; i > -1L; i -= 2L) {
            long packedOffsets = this.logFileList.get(i);
            int startOffset = Numbers.decodeLowInt(packedOffsets);
            int endOffset = Numbers.decodeHighInt(packedOffsets);
            CharSequence fileName = this.logFileNameSink.subSequence(startOffset, endOffset);
            this.path.trimTo(this.logDir.length()).concat(fileName);
            if (i == lastIndex || (totalSize += totalSize <= this.nSizeLimit ? Files.length(this.path.$()) : 0L) <= this.nSizeLimit || this.ff.removeQuiet(this.path.$())) continue;
            System.err.println("cannot remove: " + String.valueOf(this.path) + ", errno: " + this.ff.errno());
        }
    }

    private void removeExcessiveLogs(long filePointer, int type) {
        if (type == 8 && Files.notDots(filePointer)) {
            this.logFileName.of(filePointer);
            if (Utf8s.containsAscii(this.logFileName, this.logFileTemplate)) {
                this.path.trimTo(this.logDir.length()).concat(filePointer);
                int startOffset = this.logFileNameSink.length();
                this.logFileNameSink.put(this.logFileName);
                int endOffset = this.logFileNameSink.length();
                long packedOffsets = Numbers.encodeLowHighInts(startOffset, endOffset);
                this.logFileList.add(packedOffsets);
                this.logFileList.add(this.ff.getLastModified(this.path.$()));
            }
        }
    }

    private void removeExpiredLogs(long filePointer, int type) {
        if (type == 8 && Files.notDots(filePointer)) {
            this.path.trimTo(this.logDir.length()).concat(filePointer);
            this.logFileName.of(filePointer);
            if (Utf8s.containsAscii(this.logFileName, this.logFileTemplate) && this.clock.getTicks() - this.ff.getLastModified(this.path.$()) * 1000L > this.nLifeDuration && !this.ff.removeQuiet(this.path.$())) {
                throw new LogError("cannot remove: " + String.valueOf(this.path));
            }
        }
    }

    private void removeOldLogs() {
        if (this.lifeDuration != null) {
            this.ff.iterateDir(this.path.of(this.logDir).$(), this.removeExpiredLogsRef);
        }
        if (this.sizeLimit != null) {
            if (this.logFileList == null) {
                this.logFileList = new DirectLongList(2048L, 42);
            }
            if (this.logFileNameSink == null) {
                this.logFileNameSink = new DirectUtf16Sink(65536L);
            }
            this.ff.iterateDir(this.path.of(this.logDir).$(), this.removeExcessiveLogsRef);
            Vect.sort128BitAscInPlace(this.logFileList.getAddress(), this.logFileList.size() / 2L);
            this.removeExcessiveLogs();
            this.logFileNameSink.resetCapacity();
            this.logFileList.clear();
            this.logFileList.resetCapacity();
        }
    }

    @FunctionalInterface
    public static interface NextDeadline {
        public long getDeadline();
    }
}

