/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.AbstractLogRecord;
import io.questdb.log.Log;
import io.questdb.log.LogLevel;
import io.questdb.log.LogRecord;
import io.questdb.log.LogRecordUtf8Sink;
import io.questdb.log.NullLogRecord;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.std.datetime.microtime.MicrosecondClock;

public final class Logger
extends AbstractLogRecord
implements Log {
    Logger(MicrosecondClock clock, CharSequence name, RingQueue<LogRecordUtf8Sink> debugRing, Sequence debugSeq, RingQueue<LogRecordUtf8Sink> infoRing, Sequence infoSeq, RingQueue<LogRecordUtf8Sink> errorRing, Sequence errorSeq, RingQueue<LogRecordUtf8Sink> criticalRing, Sequence criticalSeq, RingQueue<LogRecordUtf8Sink> advisoryRing, Sequence advisorySeq) {
        super(clock, name, debugRing, debugSeq, infoRing, infoSeq, errorRing, errorSeq, criticalRing, criticalSeq, advisoryRing, advisorySeq);
    }

    @Override
    public LogRecord xadvisory() {
        return this.next(this.advisorySeq, this.advisoryRing, LogLevel.ADVISORY);
    }

    @Override
    public LogRecord xcritical() {
        return this.next(this.criticalSeq, this.criticalRing, LogLevel.CRITICAL);
    }

    @Override
    public LogRecord xdebug() {
        return this.next(this.debugSeq, this.debugRing, LogLevel.DEBUG);
    }

    @Override
    public LogRecord xerror() {
        return this.next(this.errorSeq, this.errorRing, LogLevel.ERROR);
    }

    @Override
    public LogRecord xinfo() {
        return this.next(this.infoSeq, this.infoRing, LogLevel.INFO);
    }

    private LogRecord next(Sequence seq, RingQueue<LogRecordUtf8Sink> ring, int level) {
        if (seq == null) {
            return NullLogRecord.INSTANCE;
        }
        long cursor = seq.next();
        if (cursor < 0L) {
            return NullLogRecord.INSTANCE;
        }
        return this.prepareLogRecord(seq, ring, level, cursor);
    }
}

