/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.preferences;

import io.questdb.PropServerConfiguration;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.file.AppendableBlock;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.json.JsonException;
import io.questdb.preferences.PreferencesMap;
import io.questdb.preferences.PreferencesParser;
import io.questdb.preferences.PreferencesUpdateListener;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class SettingsStore
implements Closeable {
    private static final String PREFERENCES_FILE_NAME = "_preferences~store";
    private final BlockFileReader blockFileReader;
    private final BlockFileWriter blockFileWriter;
    private final CairoConfiguration configuration;
    private final CharSequenceObjHashMap<CharSequence> parserMap;
    private final Path path = new Path();
    private final PreferencesMap preferencesMap;
    private final PreferencesParser preferencesParser;
    private final int rootLen;
    private PreferencesUpdateListener listener;
    private long version = 0L;

    public SettingsStore(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.preferencesMap = new PreferencesMap(configuration);
        this.parserMap = new CharSequenceObjHashMap();
        this.preferencesParser = new PreferencesParser(configuration, this.parserMap);
        this.path.of(configuration.getDbRoot());
        this.rootLen = this.path.size();
        this.blockFileWriter = new BlockFileWriter(configuration.getFilesFacade(), configuration.getCommitMode());
        this.blockFileReader = new BlockFileReader(configuration);
    }

    @Override
    public void close() throws IOException {
        Misc.free(this.preferencesParser);
        Misc.free(this.blockFileReader);
        Misc.free(this.blockFileWriter);
        Misc.free(this.path);
    }

    public synchronized void exportPreferences(Utf8StringSink settings) {
        settings.putAscii("\"preferences\":{");
        ObjList<CharSequence> keys = this.preferencesMap.keys();
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            CharSequence key = keys.getQuick(i);
            CharSequence value = this.preferencesMap.get(key);
            PropServerConfiguration.JsonPropertyValueFormatter.str(key, value, settings);
        }
        if (keys.size() > 0) {
            settings.clear(settings.size() - 1);
        }
        settings.putAscii('}');
    }

    public long getVersion() {
        return this.version;
    }

    public synchronized void init() {
        LPSZ preferencesPath = this.preferencesFilePath();
        if (this.configuration.getFilesFacade().exists(preferencesPath)) {
            this.load(preferencesPath, this.preferencesMap);
        }
    }

    public void registerListener(@NotNull PreferencesUpdateListener listener) {
        this.listener = listener;
        listener.update(this.preferencesMap);
    }

    public synchronized void save(DirectUtf8Sink sink, Mode mode, long expectedVersion) {
        if (this.version != expectedVersion) {
            throw CairoException.preferencesOutOfDate(this.version, expectedVersion);
        }
        try {
            this.preferencesParser.clear();
            this.preferencesParser.parse(sink);
        }
        catch (JsonException e) {
            throw CairoException.nonCritical().put("Malformed preferences message [error=").put(e.getFlyweightMessage()).put(", preferences=").put(sink).put(']');
        }
        switch (mode) {
            case OVERWRITE: {
                this.overwrite();
                break;
            }
            case MERGE: {
                this.merge();
                break;
            }
            default: {
                throw CairoException.nonCritical().put("Invalid mode [mode=").put(mode.name()).put(']');
            }
        }
        if (this.listener != null) {
            this.listener.update(this.preferencesMap);
        }
    }

    private void load(LPSZ preferencesPath, PreferencesMap map) {
        map.clear();
        try (BlockFileReader reader = this.blockFileReader;){
            reader.of(preferencesPath);
            this.version = map.readFromBlock(reader.getCursor());
        }
    }

    private void merge() {
        this.preferencesMap.putAll(this.parserMap);
        this.persist(this.preferencesMap);
    }

    private void overwrite() {
        this.preferencesMap.clear();
        this.merge();
    }

    private void persist(PreferencesMap map) {
        try (BlockFileWriter writer = this.blockFileWriter;){
            writer.of(this.preferencesFilePath());
            AppendableBlock block = writer.append();
            map.writeToBlock(block, ++this.version);
            writer.commit();
        }
    }

    private LPSZ preferencesFilePath() {
        return this.path.trimTo(this.rootLen).concat(PREFERENCES_FILE_NAME).$();
    }

    public static enum Mode {
        MERGE,
        OVERWRITE;


        public static Mode of(Utf8Sequence method) {
            if (HttpKeywords.isPUT(method)) {
                return OVERWRITE;
            }
            if (HttpKeywords.isPOST(method)) {
                return MERGE;
            }
            throw CairoException.nonCritical().put("Unsupported HTTP method [method=").put(method).put(']');
        }
    }
}

