/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractCharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CharSequenceBoolHashMap
extends AbstractCharSequenceHashSet {
    public static final boolean NO_ENTRY_VALUE = false;
    private final ObjList<CharSequence> list;
    private final boolean noEntryValue;
    private boolean[] values;

    public CharSequenceBoolHashMap() {
        this(8);
    }

    public CharSequenceBoolHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, false);
    }

    public CharSequenceBoolHashMap(int initialCapacity, double loadFactor, boolean noEntryValue) {
        super(initialCapacity, loadFactor);
        this.noEntryValue = noEntryValue;
        this.list = new ObjList(this.capacity);
        this.values = new boolean[this.keys.length];
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        this.list.clear();
        Arrays.fill(this.values, this.noEntryValue);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharSequenceBoolHashMap)) {
            return false;
        }
        CharSequenceBoolHashMap other = (CharSequenceBoolHashMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        ObjList<CharSequence> keys = this.keys();
        int k = keys.size();
        for (int i = 0; i < k; ++i) {
            CharSequence key = keys.get(i);
            if (this.get(key) == other.get(key)) continue;
            return false;
        }
        return true;
    }

    public boolean get(@NotNull CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public ObjList<CharSequence> keys() {
        return this.list;
    }

    public boolean put(@NotNull CharSequence key, boolean value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public void putAll(@NotNull CharSequenceBoolHashMap other) {
        CharSequence[] otherKeys = other.keys;
        boolean[] otherValues = other.values;
        int n = otherKeys.length;
        for (int i = 0; i < n; ++i) {
            if (otherKeys[i] == noEntryKey) continue;
            this.put(otherKeys[i], otherValues[i]);
        }
    }

    public boolean putAt(int index, CharSequence key, boolean value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        String keyString = Chars.toString(key);
        this.putAt0(index, keyString, value);
        this.list.add(keyString);
        return true;
    }

    public void putIfAbsent(@NotNull CharSequence key, boolean value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            String keyString = Chars.toString(key);
            this.putAt0(index, keyString, value);
            this.list.add(keyString);
        }
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            int index1 = -index - 1;
            CharSequence key = this.keys[index1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public boolean valueAt(int index) {
        int index1 = -index - 1;
        return index < 0 ? this.values[index1] : this.noEntryValue;
    }

    public boolean valueQuick(int index) {
        return this.get(this.list.getQuick(index));
    }

    private void putAt0(int index, CharSequence key, boolean value) {
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        boolean[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        int size = this.capacity - this.free;
        this.capacity *= 2;
        this.free = this.capacity - size;
        this.mask = Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor)) - 1;
        this.keys = new CharSequence[this.mask + 1];
        this.values = new boolean[this.mask + 1];
        for (int i = oldKeys.length - 1; i > -1; --i) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = this.noEntryValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }
}

