/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.Reopenable;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import java.io.Closeable;

public class DirectIntList
implements Mutable,
Closeable,
Reopenable {
    private static final Log LOG = LogFactory.getLog(DirectIntList.class);
    private final long initialCapacity;
    private final int memoryTag;
    private long address;
    private long capacity;
    private long limit;
    private long pos;

    public DirectIntList(long capacity, int memoryTag) {
        assert (capacity >= 0L);
        this.memoryTag = memoryTag;
        this.capacity = capacity * 4L;
        this.pos = this.address = capacity == 0L ? 0L : Unsafe.malloc(this.capacity, memoryTag);
        this.limit = this.pos + this.capacity;
        this.initialCapacity = this.capacity;
    }

    public void add(int x) {
        this.checkCapacity();
        Unsafe.getUnsafe().putInt(this.pos, x);
        this.pos += 4L;
    }

    public final void addAll(DirectIntList that) {
        long thatSize = that.pos - that.address;
        if (this.limit - this.pos < thatSize) {
            this.setCapacityBytes(this.capacity + thatSize - (this.limit - this.pos));
        }
        Vect.memcpy(this.pos, that.address, thatSize);
        this.pos += thatSize;
    }

    @Override
    public void clear() {
        this.pos = this.address;
    }

    public void clear(int b) {
        this.zero(b);
        this.pos = this.address;
    }

    @Override
    public void close() {
        if (this.address != 0L) {
            this.address = Unsafe.free(this.address, this.capacity, this.memoryTag);
            this.limit = 0L;
            this.pos = 0L;
            this.capacity = 0L;
        }
    }

    public int get(long p) {
        return Unsafe.getUnsafe().getInt(this.address + (p << 2));
    }

    public long getAddress() {
        return this.address;
    }

    public long getCapacity() {
        return this.capacity >>> 2;
    }

    public void removeIndexBlock(long index, long length) {
        long size = this.size();
        assert (index > -1L && length > -1L && index + length <= size);
        Vect.memcpy(this.address + (index << 2), this.address + (index + length << 2), size - index - length << 2);
        this.pos -= length << 2;
        assert (this.pos >= this.address);
    }

    public void removeLast() {
        if (this.pos == this.address) {
            return;
        }
        this.pos -= 4L;
    }

    @Override
    public void reopen() {
        if (this.address == 0L) {
            this.resetCapacity();
        }
    }

    public void resetCapacity() {
        if (this.initialCapacity == 0L) {
            this.close();
        } else {
            this.setCapacityBytes(this.initialCapacity);
        }
    }

    public void reverse() {
        long len = this.size();
        long mid = len / 2L;
        for (long index = 0L; index < mid; ++index) {
            int temp = this.get(index);
            this.set(index, this.get(len - index - 1L));
            this.set(len - index - 1L, temp);
        }
    }

    public void set(long p, int v) {
        assert (p > -1L && p < this.pos - this.address >>> 2);
        Unsafe.getUnsafe().putInt(this.address + (p << 2), v);
    }

    public void setCapacity(long capacity) {
        assert (capacity > 0L);
        this.setCapacityBytes(capacity << 2);
    }

    public void setPos(long p) {
        assert (p * 4L <= this.capacity);
        this.pos = this.address + (p << 2);
    }

    public void shrink(long newCapacity) {
        if (newCapacity < this.capacity) {
            this.setCapacityBytes(newCapacity << 2);
        }
    }

    public long size() {
        return this.pos - this.address >>> 2;
    }

    public String toString() {
        StringSink sb = Misc.getThreadLocalSink();
        sb.put('[');
        int maxElementsToPrint = 1000;
        int n = (int)Math.min(1000L, this.size());
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ((Utf16Sink)sb.put(',')).put(' ');
            }
            sb.put(this.get(i));
        }
        if (this.size() > 1000L) {
            sb.put(", .. ");
        }
        sb.put(']');
        return ((Object)sb).toString();
    }

    public void zero(int v) {
        Vect.memset(this.address, this.pos - this.address, v);
    }

    private void setCapacityBytes(long capacity) {
        assert (capacity > 0L);
        if (this.capacity != capacity) {
            if (capacity >>> 2 > 0x80000000L) {
                throw CairoException.nonCritical().put("int list capacity overflow");
            }
            long oldCapacity = this.capacity;
            long oldSize = this.pos - this.address;
            long address = Unsafe.realloc(this.address, oldCapacity, capacity, this.memoryTag);
            this.capacity = capacity;
            this.address = address;
            this.limit = address + capacity;
            this.pos = Math.min(this.limit, address + oldSize);
            LOG.debug().$("resized [old=").$(oldCapacity).$(", new=").$(this.capacity).$(']').$();
        }
    }

    void checkCapacity() {
        if (this.pos >= this.limit) {
            this.setCapacityBytes(Math.max(this.capacity, 4L) << 1);
        }
    }
}

