/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.metrics.Counter;
import io.questdb.metrics.LongGauge;
import io.questdb.metrics.NullCounter;
import io.questdb.metrics.NullLongGauge;
import io.questdb.std.AssociativeCache;
import io.questdb.std.Chars;
import io.questdb.std.Hash;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleAssociativeCache<V>
implements AssociativeCache<V> {
    private static final int MIN_BLOCKS = 1;
    private static final int MIN_ROWS = 1;
    private static final int NOT_FOUND = -1;
    private final int blockShift;
    private final int blocks;
    private final LongGauge cachedGauge;
    private final Counter hitCounter;
    private final String[] keys;
    private final Counter missCounter;
    private final int rowMask;
    private final int rows;
    private final V[] values;

    public SimpleAssociativeCache(int blocks, int rows) {
        this(blocks, rows, NullLongGauge.INSTANCE, NullCounter.INSTANCE, NullCounter.INSTANCE);
    }

    public SimpleAssociativeCache(int blocks, int rows, LongGauge cachedGauge) {
        this(blocks, rows, cachedGauge, NullCounter.INSTANCE, NullCounter.INSTANCE);
    }

    public SimpleAssociativeCache(int blocks, int rows, LongGauge cachedGauge, Counter hitCounter, Counter missCounter) {
        this.blocks = Math.max(1, Numbers.ceilPow2(blocks));
        this.rows = Math.max(1, Numbers.ceilPow2(rows));
        int capacity = this.rows * this.blocks;
        if (capacity < 0) {
            throw new OutOfMemoryError();
        }
        this.keys = new String[capacity];
        this.values = new Object[capacity];
        this.rowMask = this.rows - 1;
        this.blockShift = Numbers.msb(this.blocks);
        this.cachedGauge = cachedGauge;
        this.hitCounter = hitCounter;
        this.missCounter = missCounter;
    }

    @Override
    public int capacity() {
        return this.rows * this.blocks;
    }

    @Override
    public void clear() {
        long freed = 0L;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == null) continue;
            this.keys[i] = null;
            if (this.values[i] == null) continue;
            this.values[i] = Misc.freeIfCloseable(this.values[i]);
            ++freed;
        }
        this.cachedGauge.add(-freed);
    }

    @Override
    public void close() {
        this.clear();
    }

    public int keyIndex(CharSequence key) {
        int lo;
        int hi = lo + this.blocks;
        for (int i = lo = this.lo(key); i < hi; ++i) {
            String k = this.keys[i];
            if (k == null) {
                return -1;
            }
            if (!Chars.equals((CharSequence)k, key) || this.values[i] == null) continue;
            return i;
        }
        return -1;
    }

    public V peek(@NotNull CharSequence key) {
        return this.peek(this.keyIndex(key));
    }

    public V peek(int keyIndex) {
        if (keyIndex != -1) {
            return this.values[keyIndex];
        }
        return null;
    }

    @Override
    public V poll(@NotNull CharSequence key) {
        return this.poll(this.keyIndex(key));
    }

    @Nullable
    public V poll(int keyIndex) {
        if (keyIndex == -1) {
            this.missCounter.inc();
            return null;
        }
        V value = this.values[keyIndex];
        this.values[keyIndex] = null;
        if (value != null) {
            this.cachedGauge.dec();
            this.hitCounter.inc();
        } else {
            this.missCounter.inc();
        }
        return value;
    }

    @Override
    public void put(@NotNull CharSequence key, @Nullable V value) {
        String k;
        int lo = this.lo(key);
        int hi = lo + this.blocks;
        int reusableSlot = -1;
        for (int i = lo; i < hi && (k = this.keys[i]) != null; ++i) {
            if (!Chars.equals((CharSequence)k, key)) continue;
            if (this.values[i] == value) {
                if (i > lo) {
                    System.arraycopy(this.keys, lo, this.keys, lo + 1, i - lo);
                    System.arraycopy(this.values, lo, this.values, lo + 1, i - lo);
                    this.keys[lo] = k;
                    this.values[lo] = value;
                }
                return;
            }
            if (this.values[i] != null || reusableSlot != -1) continue;
            reusableSlot = i;
        }
        if (reusableSlot != -1) {
            String k2 = this.keys[reusableSlot];
            this.cachedGauge.inc();
            if (reusableSlot > lo) {
                System.arraycopy(this.keys, lo, this.keys, lo + 1, reusableSlot - lo);
                System.arraycopy(this.values, lo, this.values, lo + 1, reusableSlot - lo);
            }
            this.keys[lo] = k2;
            this.values[lo] = value;
            return;
        }
        V evictedValue = this.values[hi - 1];
        System.arraycopy(this.keys, lo, this.keys, lo + 1, this.blocks - 1);
        System.arraycopy(this.values, lo, this.values, lo + 1, this.blocks - 1);
        this.keys[lo] = Chars.toString(key);
        this.values[lo] = value;
        if (value != null && evictedValue == null) {
            this.cachedGauge.inc();
        } else if (value == null && evictedValue != null) {
            this.cachedGauge.dec();
        }
        Misc.freeIfCloseable(evictedValue);
    }

    private int lo(CharSequence key) {
        return (Hash.spread(Chars.hashCode(key)) & this.rowMask) << this.blockShift;
    }
}

