/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class Utf8StringObjHashMap<V>
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final ObjList<Utf8String> list;
    private final double loadFactor;
    private int capacity;
    private int free;
    private int[] hashCodes;
    private Utf8String[] keys;
    private int mask;
    private V[] values;

    public Utf8StringObjHashMap() {
        this(16);
    }

    public Utf8StringObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.4);
    }

    private Utf8StringObjHashMap(int initialCapacity, double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.capacity = initialCapacity < 16 ? 16 : Numbers.ceilPow2(initialCapacity);
        this.free = this.capacity;
        this.loadFactor = loadFactor;
        int len = Numbers.ceilPow2((int)((double)this.capacity / loadFactor));
        this.keys = new Utf8String[len];
        this.hashCodes = new int[len];
        this.mask = len - 1;
        this.list = new ObjList(this.capacity);
        this.values = new Object[this.keys.length];
        this.clear();
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.hashCodes, 0);
        this.free = this.capacity;
        this.list.clear();
    }

    public boolean contains(@NotNull DirectUtf8Sequence key) {
        return this.keyIndex(key) < 0;
    }

    public boolean excludes(@NotNull DirectUtf8Sequence key) {
        return this.keyIndex(key) > -1;
    }

    public V get(@NotNull DirectUtf8Sequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public V get(@NotNull Utf8String key) {
        return this.valueAt(this.keyIndex(key));
    }

    public int keyIndex(@NotNull DirectUtf8Sequence key) {
        int hashCode = Hash.hashUtf8(key);
        int index = Hash.spread(hashCode) & this.mask;
        if (this.keys[index] == null) {
            return index;
        }
        if (hashCode == this.hashCodes[index] && Utf8s.equals(key, this.keys[index])) {
            return -index - 1;
        }
        return this.probe(key, (long)hashCode, index);
    }

    public int keyIndex(@NotNull Utf8String key) {
        int hashCode = Hash.hashUtf8(key);
        int index = Hash.spread(hashCode) & this.mask;
        if (this.keys[index] == null) {
            return index;
        }
        if (hashCode == this.hashCodes[index] && Utf8s.equals(key, (Utf8Sequence)this.keys[index])) {
            return -index - 1;
        }
        return this.probe(key, (long)hashCode, index);
    }

    public ObjList<Utf8String> keys() {
        return this.list;
    }

    public boolean put(@NotNull Utf8String key, V value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean put(@NotNull DirectUtf8String key, V value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, @NotNull Utf8String key, V value) {
        assert (value != null);
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.keys[index] = key;
        this.hashCodes[index] = Hash.hashUtf8(key);
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
        this.list.add(key);
        return true;
    }

    public boolean putAt(int index, @NotNull DirectUtf8String key, V value) {
        Utf8String onHeapKey;
        assert (value != null);
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.keys[index] = onHeapKey = Utf8String.newInstance(key);
        this.hashCodes[index] = Hash.hashUtf8(key);
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
        this.list.add(onHeapKey);
        return true;
    }

    public int remove(@NotNull Utf8String key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            this.removeAt(index);
            return -index - 1;
        }
        return -1;
    }

    public void removeAt(int index) {
        if (index < 0) {
            Utf8String key = this.keys[-index - 1];
            this.removeAt0(index);
            this.list.remove(key);
        }
    }

    public void removeAt0(int index) {
        if (index < 0) {
            int from = -index - 1;
            this.erase(from);
            ++this.free;
            from = from + 1 & this.mask;
            Utf8String key = this.keys[from];
            while (key != null) {
                int to;
                int hashCode = Hash.hashUtf8(key);
                int idealHit = Hash.spread(hashCode) & this.mask;
                if (idealHit != from && (to = this.keys[idealHit] != null ? this.probe(key, (long)hashCode, idealHit) : idealHit) > -1) {
                    this.move(from, to);
                }
                from = from + 1 & this.mask;
                key = this.keys[from];
            }
        }
    }

    public int size() {
        return this.capacity - this.free;
    }

    public V valueAt(int index) {
        return index < 0 ? (V)this.valueAtQuick(index) : null;
    }

    public V valueAtQuick(int index) {
        return this.values[-index - 1];
    }

    public V valueQuick(int index) {
        return this.get(this.list.getQuick(index));
    }

    private void erase(int index) {
        this.keys[index] = null;
        this.hashCodes[index] = 0;
        this.values[index] = null;
    }

    private void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.hashCodes[to] = this.hashCodes[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    private int probe(DirectUtf8Sequence key, long hashCode, int index) {
        do {
            if (this.keys[index = index + 1 & this.mask] != null) continue;
            return index;
        } while (hashCode != (long)this.hashCodes[index] || !Utf8s.equals(key, this.keys[index]));
        return -index - 1;
    }

    private int probe(Utf8String key, long hashCode, int index) {
        do {
            if (this.keys[index = index + 1 & this.mask] != null) continue;
            return index;
        } while (hashCode != (long)this.hashCodes[index] || !Utf8s.equals(key, (Utf8Sequence)this.keys[index]));
        return -index - 1;
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        V[] oldValues = this.values;
        Utf8String[] oldKeys = this.keys;
        int[] oldHashCodes = this.hashCodes;
        this.keys = new Utf8String[len];
        this.hashCodes = new int[len];
        this.values = new Object[len];
        Arrays.fill(this.keys, null);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            Utf8String key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.hashCodes[index] = oldHashCodes[i];
            this.values[index] = oldValues[i];
        }
    }
}

