/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.histogram.org.HdrHistogram.packedarray;

import io.questdb.std.histogram.org.HdrHistogram.packedarray.AbstractPackedArrayContext;
import io.questdb.std.histogram.org.HdrHistogram.packedarray.AbstractPackedLongArray;
import io.questdb.std.histogram.org.HdrHistogram.packedarray.IterationValue;
import io.questdb.std.histogram.org.HdrHistogram.packedarray.PackedArrayContext;

public class PackedLongArray
extends AbstractPackedLongArray {
    public PackedLongArray(int virtualLength) {
        this(virtualLength, 16);
    }

    public PackedLongArray(int virtualLength, int initialPhysicalLength) {
        this.setArrayContext(new PackedArrayContext(virtualLength, initialPhysicalLength));
    }

    @Override
    public PackedLongArray copy() {
        PackedLongArray copy = new PackedLongArray(this.length(), this.getPhysicalLength());
        copy.add(this);
        return copy;
    }

    @Override
    public void setVirtualLength(int newVirtualArrayLength) {
        if (newVirtualArrayLength < this.length()) {
            throw new IllegalArgumentException("Cannot set virtual length, as requested length " + newVirtualArrayLength + " is smaller than the current virtual length " + this.length());
        }
        AbstractPackedArrayContext currentArrayContext = this.getArrayContext();
        if (currentArrayContext.isPacked() && currentArrayContext.determineTopLevelShiftForVirtualLength(newVirtualArrayLength) == currentArrayContext.getTopLevelShift()) {
            currentArrayContext.setVirtualLength(newVirtualArrayLength);
            return;
        }
        this.setArrayContext(new PackedArrayContext(newVirtualArrayLength, currentArrayContext, currentArrayContext.length()));
        for (IterationValue v : currentArrayContext.nonZeroValues()) {
            this.set(v.getIndex(), v.getValue());
        }
    }

    @Override
    void clearContents() {
        this.getArrayContext().clearContents();
    }

    @Override
    long criticalSectionEnter() {
        return 0L;
    }

    @Override
    void criticalSectionExit(long criticalValueAtEnter) {
    }

    @Override
    void resizeStorageArray(int newPhysicalLengthInLongs) {
        AbstractPackedArrayContext oldArrayContext = this.getArrayContext();
        PackedArrayContext newArrayContext = new PackedArrayContext(oldArrayContext.getVirtualLength(), oldArrayContext, newPhysicalLengthInLongs);
        this.setArrayContext(newArrayContext);
        for (IterationValue v : oldArrayContext.nonZeroValues()) {
            this.set(v.getIndex(), v.getValue());
        }
    }
}

