/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.apache.hertzbeat.common.entity.manager.StatusPageComponent;
import org.apache.hertzbeat.common.entity.manager.StatusPageIncidentContent;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_status_page_incident")
@Schema(description="status page incident entity")
@EntityListeners(value={AuditingEntityListener.class})
public class StatusPageIncident {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="ID", example="87584674384")
    private Long id;
    @Schema(title="org id", example="1234")
    private Long orgId;
    @Schema(title="incident name", example="Gateway")
    @NotBlank
    private String name;
    @Schema(title="incident current state: 0-Investigating 1-Identified 2-Monitoring 3-Resolved", example="0")
    private byte state;
    @Schema(title="incident start Investigating timestamp", example="4248574985744")
    private Long startTime;
    @Schema(title="incident end Resolved timestamp", example="4248574985744")
    private Long endTime;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom")
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="1612198922000")
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000")
    @LastModifiedDate
    private LocalDateTime gmtUpdate;
    @Schema(title="status page components")
    @ManyToMany(targetEntity=StatusPageComponent.class, cascade={CascadeType.MERGE}, fetch=FetchType.EAGER)
    @JoinTable(name="hzb_status_page_incident_component_bind", foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT), inverseForeignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT), joinColumns={@JoinColumn(name="incident_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="component_id", referencedColumnName="id")})
    private List<StatusPageComponent> components;
    @Schema(title="status page incident content")
    @OneToMany(targetEntity=StatusPageIncidentContent.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="incident_id", referencedColumnName="id")
    private Set<StatusPageIncidentContent> contents;

    public static StatusPageIncidentBuilder builder() {
        return new StatusPageIncidentBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public String getName() {
        return this.name;
    }

    public byte getState() {
        return this.state;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public List<StatusPageComponent> getComponents() {
        return this.components;
    }

    public Set<StatusPageIncidentContent> getContents() {
        return this.contents;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public void setComponents(List<StatusPageComponent> components) {
        this.components = components;
    }

    public void setContents(Set<StatusPageIncidentContent> contents) {
        this.contents = contents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusPageIncident)) {
            return false;
        }
        StatusPageIncident other = (StatusPageIncident)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        if (this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate)) {
            return false;
        }
        List<StatusPageComponent> this$components = this.getComponents();
        List<StatusPageComponent> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        Set<StatusPageIncidentContent> this$contents = this.getContents();
        Set<StatusPageIncidentContent> other$contents = other.getContents();
        return !(this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatusPageIncident;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getState();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        List<StatusPageComponent> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        Set<StatusPageIncidentContent> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        return result;
    }

    public String toString() {
        return "StatusPageIncident(id=" + this.getId() + ", orgId=" + this.getOrgId() + ", name=" + this.getName() + ", state=" + this.getState() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ", components=" + this.getComponents() + ", contents=" + this.getContents() + ")";
    }

    public StatusPageIncident(Long id, Long orgId, String name, byte state, Long startTime, Long endTime, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate, List<StatusPageComponent> components, Set<StatusPageIncidentContent> contents) {
        this.id = id;
        this.orgId = orgId;
        this.name = name;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
        this.components = components;
        this.contents = contents;
    }

    public StatusPageIncident() {
    }

    public static class StatusPageIncidentBuilder {
        private Long id;
        private Long orgId;
        private String name;
        private byte state;
        private Long startTime;
        private Long endTime;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;
        private List<StatusPageComponent> components;
        private Set<StatusPageIncidentContent> contents;

        StatusPageIncidentBuilder() {
        }

        public StatusPageIncidentBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StatusPageIncidentBuilder orgId(Long orgId) {
            this.orgId = orgId;
            return this;
        }

        public StatusPageIncidentBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StatusPageIncidentBuilder state(byte state) {
            this.state = state;
            return this;
        }

        public StatusPageIncidentBuilder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public StatusPageIncidentBuilder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public StatusPageIncidentBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public StatusPageIncidentBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public StatusPageIncidentBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public StatusPageIncidentBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public StatusPageIncidentBuilder components(List<StatusPageComponent> components) {
            this.components = components;
            return this;
        }

        public StatusPageIncidentBuilder contents(Set<StatusPageIncidentContent> contents) {
            this.contents = contents;
            return this;
        }

        public StatusPageIncident build() {
            return new StatusPageIncident(this.id, this.orgId, this.name, this.state, this.startTime, this.endTime, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate, this.components, this.contents);
        }

        public String toString() {
            return "StatusPageIncident.StatusPageIncidentBuilder(id=" + this.id + ", orgId=" + this.orgId + ", name=" + this.name + ", state=" + this.state + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ", components=" + this.components + ", contents=" + this.contents + ")";
        }
    }
}

