/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.html;

import cn.afterturn.easypoi.excel.entity.ExcelToHtmlParams;
import cn.afterturn.easypoi.excel.html.helper.CellValueHelper;
import cn.afterturn.easypoi.excel.html.helper.MergedRegionHelper;
import cn.afterturn.easypoi.excel.html.helper.StyleHelper;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelToHtmlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelToHtmlService.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy_MM_dd");
    private String today;
    private Workbook wb;
    private int sheetNum;
    private int cssRandom;
    private boolean completeHTML;
    private Formatter out;
    private boolean gotBounds;
    private int firstColumn;
    private int endColumn;
    private String imageCachePath;
    private boolean showRowNum;
    private boolean showColumnHead;
    private static final String COL_HEAD_CLASS = "colHeader";
    private static final String ROW_HEAD_CLASS = "rowHeader";
    private static final String DEFAULTS_CLASS = "excelDefaults";
    private Map<String, PictureData> pictures = new HashMap<String, PictureData>();

    public ExcelToHtmlService(ExcelToHtmlParams params) {
        this.wb = params.getWb();
        this.completeHTML = params.isCompleteHTML();
        this.sheetNum = params.getSheetNum();
        this.cssRandom = (int)Math.ceil(Math.random() * 1000.0);
        this.imageCachePath = params.getPath();
        this.showRowNum = params.isShowRowNum();
        this.showColumnHead = params.isShowColumnHead();
        this.today = new SimpleDateFormat("yyyy_MM_dd").format(new Date());
    }

    public String printPage() {
        try {
            this.ensureOut();
            if (this.completeHTML) {
                this.out.format("<!DOCTYPE HTML>%n", new Object[0]);
                this.out.format("<html>%n", new Object[0]);
                this.out.format("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">%n", new Object[0]);
                this.out.format("<head>%n", new Object[0]);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.imageCachePath)) {
                this.getPictures();
            }
            new StyleHelper(this.wb, this.out, this.sheetNum, this.cssRandom);
            if (this.completeHTML) {
                this.out.format("</head>%n", new Object[0]);
                this.out.format("<body>%n", new Object[0]);
            }
            this.print();
            if (this.completeHTML) {
                this.out.format("</body>%n", new Object[0]);
                this.out.format("</html>%n", new Object[0]);
            }
            String string = this.out.toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
        }
        return null;
    }

    private void getPictures() {
        this.pictures = this.wb instanceof XSSFWorkbook ? PoiPublicUtil.getSheetPictrues07((XSSFSheet)this.wb.getSheetAt(this.sheetNum), (XSSFWorkbook)this.wb) : PoiPublicUtil.getSheetPictrues03((HSSFSheet)this.wb.getSheetAt(this.sheetNum), (HSSFWorkbook)this.wb);
    }

    private void print() {
        this.printSheets();
    }

    private void ensureOut() {
        if (this.out == null) {
            this.out = new Formatter(new StringBuilder());
        }
    }

    private void printSheets() {
        Sheet sheet = this.wb.getSheetAt(this.sheetNum);
        this.printSheet(sheet);
    }

    private void printSheet(Sheet sheet) {
        this.out.format("<table class='%s' width='%spx;'>%n", DEFAULTS_CLASS, this.getTableWidth(sheet));
        this.printCols(sheet);
        this.printSheetContent(sheet);
        this.out.format("</table>%n", new Object[0]);
    }

    private void printCols(Sheet sheet) {
        if (this.showRowNum) {
            this.out.format("<col style='width:%spx;'/>%n", PoiPublicUtil.getNumDigits(sheet.getLastRowNum()) * 18);
        }
        this.ensureColumnBounds(sheet);
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            this.out.format("<col style='width:%spx;' />%n", sheet.getColumnWidth(i) / 16);
        }
    }

    private int getTableWidth(Sheet sheet) {
        this.ensureColumnBounds(sheet);
        int width = 0;
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            width += sheet.getColumnWidth(i) / 16;
        }
        return width;
    }

    private void ensureColumnBounds(Sheet sheet) {
        if (this.gotBounds) {
            return;
        }
        int lastRow = sheet.getLastRowNum();
        this.firstColumn = lastRow > 1 ? Integer.MAX_VALUE : 0;
        this.endColumn = 0;
        for (int i = 0; i < lastRow; ++i) {
            Row row = sheet.getRow(i);
            short firstCell = row.getFirstCellNum();
            if (firstCell < 0) continue;
            this.firstColumn = Math.min(this.firstColumn, firstCell);
            this.endColumn = Math.max(this.endColumn, row.getLastCellNum());
        }
        this.gotBounds = true;
    }

    private void printColumnHeads(Sheet sheet) {
        this.out.format("<thead>%n", new Object[0]);
        this.out.format("  <tr class=%s>%n", COL_HEAD_CLASS);
        this.out.format("    <th class=%s>&#x25CA;</th>%n", COL_HEAD_CLASS);
        StringBuilder colName = new StringBuilder();
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            colName.setLength(0);
            int cnum = i;
            do {
                colName.insert(0, (char)(65 + cnum % 26));
            } while ((cnum /= 26) > 0);
            this.out.format("    <th class=%s>%s</th>%n", COL_HEAD_CLASS, colName);
        }
        this.out.format("  </tr>%n", new Object[0]);
        this.out.format("</thead>%n", new Object[0]);
    }

    private void printSheetContent(Sheet sheet) {
        if (this.showColumnHead) {
            this.printColumnHeads(sheet);
        }
        MergedRegionHelper mergedRegionHelper = new MergedRegionHelper(sheet);
        CellValueHelper cellValueHelper = new CellValueHelper(this.wb, this.cssRandom);
        this.out.format("<tbody>%n", new Object[0]);
        Iterator rows = sheet.rowIterator();
        int rowIndex = 1;
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            this.out.format("  <tr style='height:%spx;'>%n", row.getHeight() / 15);
            if (this.showRowNum) {
                this.out.format("    <td style='font-size:12px;' >%d</td>%n", row.getRowNum() + 1);
            }
            for (int i = this.firstColumn; i < this.endColumn; ++i) {
                Cell cell;
                if (!mergedRegionHelper.isNeedCreate(rowIndex, i)) continue;
                String content = "&nbsp;";
                CellStyle style = null;
                if (i >= row.getFirstCellNum() && i < row.getLastCellNum() && (cell = row.getCell(i)) != null) {
                    style = cell.getCellStyle();
                    content = cellValueHelper.getHtmlValue(cell);
                }
                if (this.pictures.containsKey(rowIndex - 1 + "_" + i)) {
                    content = "<img src='data:image/" + PoiPublicUtil.getFileExtendName(this.pictures.get(rowIndex - 1 + "_" + i).getData()) + ";base64," + this.getImageSrc(this.pictures.get(rowIndex - 1 + "_" + i)) + "' style='max-width:  " + this.getImageMaxWidth(mergedRegionHelper.getRowAndColSpan(rowIndex, i), i, sheet) + "px;' />";
                }
                if (mergedRegionHelper.isMergedRegion(rowIndex, i)) {
                    Integer[] rowAndColSpan = mergedRegionHelper.getRowAndColSpan(rowIndex, i);
                    this.out.format("    <td rowspan='%s' colspan='%s' class='%s' >%s</td>%n", rowAndColSpan[0], rowAndColSpan[1], this.styleName(style), content);
                    continue;
                }
                this.out.format("    <td class='%s'>%s</td>%n", this.styleName(style), content);
            }
            this.out.format("  </tr>%n", new Object[0]);
            ++rowIndex;
        }
        this.out.format("</tbody>%n", new Object[0]);
    }

    private int getImageMaxWidth(Integer[] rowAndColSpan, int colIndex, Sheet sheet) {
        if (rowAndColSpan == null) {
            return sheet.getColumnWidth(colIndex) / 32;
        }
        int maxWidth = 0;
        for (int i = 0; i < rowAndColSpan[1]; ++i) {
            maxWidth += sheet.getColumnWidth(colIndex + i) / 32;
        }
        return maxWidth;
    }

    private String getImageSrc(PictureData pictureData) {
        if (pictureData == null) {
            return "";
        }
        byte[] data = pictureData.getData();
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(data);
    }

    private String styleName(CellStyle style) {
        if (style == null) {
            return "";
        }
        return String.format("style_%02x_%s font_%s_%s", style.getIndex(), this.cssRandom, style.getFontIndex(), this.cssRandom);
    }
}

