/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.log.service.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.common.v1.KeyValueList;
import io.opentelemetry.proto.logs.v1.LogRecord;
import io.opentelemetry.proto.logs.v1.ResourceLogs;
import io.opentelemetry.proto.logs.v1.ScopeLogs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.log.notice.LogSseManager;
import org.apache.hertzbeat.log.service.LogProtocolAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OtlpLogProtocolAdapter
implements LogProtocolAdapter {
    private static final Logger log = LoggerFactory.getLogger(OtlpLogProtocolAdapter.class);
    private static final String PROTOCOL_NAME = "otlp";
    private final CommonDataQueue commonDataQueue;
    private final LogSseManager logSseManager;

    public OtlpLogProtocolAdapter(CommonDataQueue commonDataQueue, LogSseManager logSseManager) {
        this.commonDataQueue = commonDataQueue;
        this.logSseManager = logSseManager;
    }

    @Override
    public void ingest(String content) {
        if (content == null || content.isEmpty()) {
            log.warn("Received empty OTLP JSON log payload - skip processing.");
            return;
        }
        ExportLogsServiceRequest.Builder builder = ExportLogsServiceRequest.newBuilder();
        try {
            JsonFormat.parser().ignoringUnknownFields().merge(content, (Message.Builder)builder);
            ExportLogsServiceRequest request = builder.build();
            this.processLogsRequest(request, "JSON");
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Failed to parse OTLP JSON log payload: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Invalid OTLP JSON log content", e);
        }
    }

    public void ingestBinary(byte[] content) {
        if (content == null || content.length == 0) {
            log.warn("Received empty OTLP binary log payload - skip processing.");
            return;
        }
        try {
            ExportLogsServiceRequest request = ExportLogsServiceRequest.parseFrom((byte[])content);
            this.processLogsRequest(request, "binary");
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Failed to parse OTLP binary log payload: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Invalid OTLP binary log content", e);
        }
    }

    private void processLogsRequest(ExportLogsServiceRequest request, String format) {
        List<LogEntry> logEntries = this.extractLogEntries(request);
        log.debug("Successfully extracted {} log entries from OTLP {} payload", (Object)logEntries.size(), (Object)format);
        this.commonDataQueue.sendLogEntryToStorageBatch(logEntries);
        this.commonDataQueue.sendLogEntryToAlertBatch(logEntries);
        logEntries.forEach(this.logSseManager::broadcast);
    }

    private List<LogEntry> extractLogEntries(ExportLogsServiceRequest request) {
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
        for (ResourceLogs resourceLogs : request.getResourceLogsList()) {
            Map<String, Object> resourceAttributes = this.extractAttributes(resourceLogs.getResource().getAttributesList());
            for (ScopeLogs scopeLogs : resourceLogs.getScopeLogsList()) {
                LogEntry.InstrumentationScope instrumentationScope = this.extractInstrumentationScope(scopeLogs);
                for (LogRecord logRecord : scopeLogs.getLogRecordsList()) {
                    LogEntry logEntry = this.convertLogRecordToLogEntry(logRecord, resourceAttributes, instrumentationScope);
                    logEntries.add(logEntry);
                }
            }
        }
        return logEntries;
    }

    private LogEntry convertLogRecordToLogEntry(LogRecord logRecord, Map<String, Object> resourceAttributes, LogEntry.InstrumentationScope instrumentationScope) {
        return LogEntry.builder().timeUnixNano(Long.valueOf(logRecord.getTimeUnixNano())).observedTimeUnixNano(Long.valueOf(logRecord.getObservedTimeUnixNano())).severityNumber(Integer.valueOf(logRecord.getSeverityNumberValue())).severityText(logRecord.getSeverityText()).body(this.extractBody(logRecord.getBody())).attributes(this.extractAttributes(logRecord.getAttributesList())).droppedAttributesCount(Integer.valueOf(logRecord.getDroppedAttributesCount())).traceId(this.bytesToHex(logRecord.getTraceId().toByteArray())).spanId(this.bytesToHex(logRecord.getSpanId().toByteArray())).traceFlags(Integer.valueOf(logRecord.getFlags())).resource(resourceAttributes).instrumentationScope(instrumentationScope).build();
    }

    private LogEntry.InstrumentationScope extractInstrumentationScope(ScopeLogs scopeLogs) {
        if (!scopeLogs.hasScope()) {
            return null;
        }
        InstrumentationScope scope = scopeLogs.getScope();
        return LogEntry.InstrumentationScope.builder().name(scope.getName()).version(scope.getVersion()).attributes(this.extractAttributes(scope.getAttributesList())).droppedAttributesCount(Integer.valueOf(scope.getDroppedAttributesCount())).build();
    }

    private Map<String, Object> extractAttributes(List<KeyValue> keyValueList) {
        if (keyValueList == null || keyValueList.isEmpty()) {
            return new HashMap<String, Object>();
        }
        AnyValue anyValue = AnyValue.newBuilder().setKvlistValue(KeyValueList.newBuilder().addAllValues(keyValueList).build()).build();
        Object extractedAnyValue = this.extractAnyValue(anyValue);
        if (extractedAnyValue instanceof Map) {
            Map genericMap = (Map)extractedAnyValue;
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (Map.Entry entry : genericMap.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                resultMap.put((String)entry.getKey(), entry.getValue());
            }
            return resultMap;
        }
        return new HashMap<String, Object>();
    }

    private Object extractBody(AnyValue body) {
        return this.extractAnyValue(body);
    }

    private Object extractAnyValue(AnyValue anyValue) {
        switch (anyValue.getValueCase()) {
            case STRING_VALUE: {
                return anyValue.getStringValue();
            }
            case BOOL_VALUE: {
                return anyValue.getBoolValue();
            }
            case INT_VALUE: {
                return anyValue.getIntValue();
            }
            case DOUBLE_VALUE: {
                return anyValue.getDoubleValue();
            }
            case ARRAY_VALUE: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (AnyValue item : anyValue.getArrayValue().getValuesList()) {
                    arrayList.add(this.extractAnyValue(item));
                }
                return arrayList;
            }
            case KVLIST_VALUE: {
                HashMap<String, Object> kvMap = new HashMap<String, Object>();
                for (KeyValue kv : anyValue.getKvlistValue().getValuesList()) {
                    kvMap.put(this.normalizeKey(kv.getKey()), this.extractAnyValue(kv.getValue()));
                }
                return kvMap;
            }
            case BYTES_VALUE: {
                return anyValue.getBytesValue().toByteArray();
            }
        }
        return null;
    }

    private String normalizeKey(String key) {
        if (key == null) {
            return null;
        }
        return key.replace(".", "_").replace(" ", "_");
    }

    private String bytesToHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Override
    public String supportProtocol() {
        return PROTOCOL_NAME;
    }
}

