/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.retry;

import com.huaweicloud.sdk.core.exception.SdkException;

public final class RetryContext<ResT> {
    private final int retriesAttempted;
    private final int statusCode;
    private final ResT lastResponse;
    private final SdkException lastException;

    private RetryContext(int retriesAttempted, int statusCode, ResT lastResponse, SdkException lastException) {
        this.retriesAttempted = retriesAttempted;
        this.statusCode = statusCode;
        this.lastResponse = lastResponse;
        this.lastException = lastException;
    }

    public int getRetriesAttempted() {
        return this.retriesAttempted;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ResT getLastResponse() {
        return this.lastResponse;
    }

    public SdkException getLastException() {
        return this.lastException;
    }

    public static <ResT> Builder<ResT> builder() {
        return new Builder();
    }

    public static class Builder<ResT> {
        private int retriesAttempted;
        private int statusCode;
        private ResT lastResponse;
        private SdkException lastException;

        private Builder() {
        }

        public Builder<ResT> withRetriesAttempted(int retriesAttempted) {
            this.retriesAttempted = retriesAttempted;
            return this;
        }

        public Builder<ResT> withStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder<ResT> withLastResponse(ResT lastResponse) {
            this.lastResponse = lastResponse;
            return this;
        }

        public Builder<ResT> withLastException(SdkException lastException) {
            this.lastException = lastException;
            return this;
        }

        public RetryContext<ResT> build() {
            return new RetryContext(this.retriesAttempted, this.statusCode, this.lastResponse, this.lastException);
        }
    }
}

