/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.sd;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.HttpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.entity.sd.ConnectionConfig;
import org.apache.hertzbeat.common.entity.sd.ServiceDiscoveryResponseEntity;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriUtils;

public class HttpSdCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(HttpSdCollectImpl.class);

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        ArrayList configList = Lists.newArrayList();
        HttpUriRequest request = this.createHttpRequest(metrics.getHttp_sd());
        HttpContext httpContext = this.createHttpContext(metrics.getHttp_sd());
        try (CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request, httpContext);){
            TypeReference<List<ServiceDiscoveryResponseEntity>> typeReference;
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.warn("Failed to fetch sd...");
                builder.setMsg("StatusCode " + statusCode);
                builder.setCode(CollectRep.Code.FAIL);
                return;
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            List responseEntityList = (List)JsonUtil.fromJson((String)responseBody, (TypeReference)(typeReference = new TypeReference<List<ServiceDiscoveryResponseEntity>>(){}));
            if (CollectionUtils.isEmpty((Collection)responseEntityList)) {
                return;
            }
            responseEntityList.stream().filter(entity -> !CollectionUtils.isEmpty((Collection)entity.getTarget())).forEach(responseEntity -> this.convertTarget(configList, (ServiceDiscoveryResponseEntity)responseEntity));
            configList.forEach(config -> {
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                valueRowBuilder.addColumn(config.getHost());
                valueRowBuilder.addColumn(config.getPort());
                builder.addValueRow(valueRowBuilder.build());
            });
        }
        catch (IOException e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn("Failed to fetch sd... {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    private void convertTarget(List<ConnectionConfig> configList, ServiceDiscoveryResponseEntity responseEntity) {
        responseEntity.getTarget().stream().filter(org.apache.commons.lang3.StringUtils::isNotBlank).forEach(fetchedTarget -> this.addConfig(configList, (String)fetchedTarget));
    }

    private void addConfig(List<ConnectionConfig> configList, String fetchedTarget) {
        for (String url : fetchedTarget.split(",")) {
            String[] split = url.split(":");
            if (split.length != 2) continue;
            configList.add(ConnectionConfig.builder().host(split[0]).port(split[1]).build());
        }
    }

    public String supportProtocol() {
        return "http_sd";
    }

    public HttpContext createHttpContext(HttpProtocol httpSdProtocol) {
        HttpProtocol.Authorization auth = httpSdProtocol.getAuthorization();
        if (auth != null && "Digest Auth".equals(auth.getType())) {
            HttpClientContext clientContext = new HttpClientContext();
            if (StringUtils.hasText((String)auth.getDigestAuthUsername()) && StringUtils.hasText((String)auth.getDigestAuthPassword())) {
                URL url;
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(auth.getDigestAuthUsername(), auth.getDigestAuthPassword());
                try {
                    url = new URL(httpSdProtocol.getUrl());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Invalid URI format.", e);
                }
                int port = url.getPort() != -1 ? url.getPort() : ("https".equals(url.getProtocol()) ? 443 : 80);
                AuthScope authScope = new AuthScope(url.getHost(), port);
                provider.setCredentials(authScope, (Credentials)credentials);
                clientContext.setCredentialsProvider((CredentialsProvider)provider);
                return clientContext;
            }
        }
        return null;
    }

    public HttpUriRequest createHttpRequest(HttpProtocol httpSdProtocol) {
        boolean enableUrlEncoding;
        RequestBuilder requestBuilder = RequestBuilder.get();
        requestBuilder.addHeader("Connection", "Keep-Alive");
        requestBuilder.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.76 Safari/537.36");
        Map headers = httpSdProtocol.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry header : headers.entrySet()) {
                if (!StringUtils.hasText((String)((String)header.getValue()))) continue;
                requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        requestBuilder.addHeader("Accept", "application/json");
        if (httpSdProtocol.getAuthorization() != null) {
            HttpProtocol.Authorization authorization = httpSdProtocol.getAuthorization();
            if ("Bearer Token".equalsIgnoreCase(authorization.getType())) {
                String value = "Bearer " + authorization.getBearerTokenToken();
                requestBuilder.addHeader("Authorization", value);
            } else if ("Basic Auth".equals(authorization.getType()) && StringUtils.hasText((String)authorization.getBasicAuthUsername()) && StringUtils.hasText((String)authorization.getBasicAuthPassword())) {
                String authStr = authorization.getBasicAuthUsername() + ":" + authorization.getBasicAuthPassword();
                String encodedAuth = Base64Util.encode((String)authStr);
                requestBuilder.addHeader("Authorization", "Basic " + encodedAuth);
            }
        }
        if (enableUrlEncoding = Boolean.parseBoolean(httpSdProtocol.getEnableUrlEncoding())) {
            if (httpSdProtocol.getUrl().contains("?")) {
                String path = httpSdProtocol.getUrl().substring(0, httpSdProtocol.getUrl().indexOf("?"));
                String query = httpSdProtocol.getUrl().substring(httpSdProtocol.getUrl().indexOf("?") + 1);
                httpSdProtocol.setUrl(UriUtils.encodePath((String)path, (String)"UTF-8") + "?" + UriUtils.encodeQuery((String)query, (String)"UTF-8"));
            } else {
                httpSdProtocol.setUrl(UriUtils.encodePath((String)httpSdProtocol.getUrl(), (String)"UTF-8"));
            }
        }
        try {
            requestBuilder.setUri(httpSdProtocol.getUrl());
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid URI with illegal characters: {}. User has disabled URL encoding, not applying any encoding.", (Object)httpSdProtocol.getUrl());
            throw e;
        }
        int timeout = CollectUtil.getTimeout((String)httpSdProtocol.getTimeout(), (int)0);
        if (timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        }
        return requestBuilder.build();
    }
}

