/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class PropertyPath
implements Streamable<PropertyPath> {
    private static final String PARSE_DEPTH_EXCEEDED = "Trying to parse a path with depth greater than 1000; This has been disabled for security reasons to prevent parsing overflows";
    private static final String DELIMITERS = "_\\.";
    private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
    private static final Pattern SPLITTER_FOR_QUOTED = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "\\."));
    private static final Pattern NESTED_PROPERTY_PATTERN = Pattern.compile("\\p{Lu}[\\p{Ll}\\p{Nd}]*$");
    private static final Map<Property, PropertyPath> cache = new ConcurrentReferenceHashMap();
    private final TypeInformation<?> owningType;
    private final String name;
    private final TypeInformation<?> typeInformation;
    private final TypeInformation<?> actualTypeInformation;
    private final boolean isCollection;
    @Nullable
    private PropertyPath next;

    PropertyPath(String name, Class<?> owningType) {
        this(name, TypeInformation.of(owningType), Collections.emptyList());
    }

    PropertyPath(String name, TypeInformation<?> owningType, List<PropertyPath> base) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        Assert.notNull(owningType, (String)"Owning type must not be null");
        Assert.notNull(base, (String)"Previously found properties must not be null");
        String decapitalized = Introspector.decapitalize(name);
        Property property = PropertyPath.lookupProperty(owningType, decapitalized);
        if (property == null) {
            property = PropertyPath.lookupProperty(owningType, StringUtils.uncapitalize((String)name));
        }
        if (property == null) {
            throw new PropertyReferenceException(decapitalized, owningType, base);
        }
        this.owningType = owningType;
        this.name = property.path;
        this.typeInformation = property.type;
        this.isCollection = this.typeInformation.isCollectionLike();
        this.actualTypeInformation = this.typeInformation.getActualType() == null ? this.typeInformation : this.typeInformation.getRequiredActualType();
    }

    @Nullable
    private static Property lookupProperty(TypeInformation<?> owningType, String name) {
        TypeInformation<?> propertyType = owningType.getProperty(name);
        return propertyType != null ? new Property(propertyType, name) : null;
    }

    public TypeInformation<?> getOwningType() {
        return this.owningType;
    }

    public String getSegment() {
        return this.name;
    }

    public PropertyPath getLeafProperty() {
        PropertyPath result = this;
        while (result.hasNext()) {
            result = result.requiredNext();
        }
        return result;
    }

    public Class<?> getLeafType() {
        return this.getLeafProperty().getType();
    }

    public Class<?> getType() {
        return this.actualTypeInformation.getType();
    }

    public TypeInformation<?> getTypeInformation() {
        return this.typeInformation;
    }

    @Nullable
    public PropertyPath next() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public String toDotPath() {
        if (this.hasNext()) {
            return this.getSegment() + "." + this.requiredNext().toDotPath();
        }
        return this.getSegment();
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public PropertyPath nested(String path) {
        Assert.hasText((String)path, (String)"Path must not be null or empty");
        String lookup = this.toDotPath().concat(".").concat(path);
        return PropertyPath.from(lookup, this.owningType);
    }

    @Override
    public Iterator<PropertyPath> iterator() {
        return new Iterator<PropertyPath>(){
            @Nullable
            private PropertyPath current;
            {
                this.current = PropertyPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            @Nullable
            public PropertyPath next() {
                PropertyPath result = this.current;
                if (result == null) {
                    return null;
                }
                this.current = result.next();
                return result;
            }
        };
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyPath)) {
            return false;
        }
        PropertyPath that = (PropertyPath)o;
        if (this.isCollection != that.isCollection) {
            return false;
        }
        return Objects.equals(this.owningType, that.owningType) && Objects.equals(this.name, that.name) && Objects.equals(this.typeInformation, that.typeInformation) && Objects.equals(this.actualTypeInformation, that.actualTypeInformation) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        return Objects.hash(this.owningType, this.name, this.typeInformation, this.actualTypeInformation, this.isCollection, this.next);
    }

    private PropertyPath requiredNext() {
        PropertyPath result = this.next;
        if (result == null) {
            throw new IllegalStateException("No next path available; Clients should call hasNext() before invoking this method");
        }
        return result;
    }

    public static PropertyPath from(String source, Class<?> type) {
        return PropertyPath.from(source, TypeInformation.of(type));
    }

    public static PropertyPath from(String source, TypeInformation<?> type) {
        Assert.hasText((String)source, (String)"Source must not be null or empty");
        Assert.notNull(type, (String)"TypeInformation must not be null or empty");
        return cache.computeIfAbsent(new Property(type, source), it -> {
            Matcher matcher;
            ArrayList<String> iteratorSource = new ArrayList<String>();
            Matcher matcher2 = matcher = PropertyPath.isQuoted(it.path) ? SPLITTER_FOR_QUOTED.matcher(it.path.replace("\\Q", "").replace("\\E", "")) : SPLITTER.matcher("_" + it.path);
            while (matcher.find()) {
                iteratorSource.add(matcher.group(1));
            }
            Iterator parts = iteratorSource.iterator();
            PropertyPath result = null;
            Stack<PropertyPath> current = new Stack<PropertyPath>();
            while (parts.hasNext()) {
                if (result == null) {
                    result = PropertyPath.create((String)parts.next(), it.type, current);
                    current.push(result);
                    continue;
                }
                current.push(PropertyPath.create((String)parts.next(), current));
            }
            if (result == null) {
                throw new IllegalStateException(String.format("Expected parsing to yield a PropertyPath from %s but got null", source));
            }
            return result;
        });
    }

    private static boolean isQuoted(String source) {
        return source.matches("^\\\\Q.*\\\\E$");
    }

    private static PropertyPath create(String source, Stack<PropertyPath> base) {
        PropertyPath propertyPath;
        PropertyPath previous = base.peek();
        previous.next = propertyPath = PropertyPath.create(source, previous.typeInformation.getRequiredActualType(), base);
        return propertyPath;
    }

    private static PropertyPath create(String source, TypeInformation<?> type, List<PropertyPath> base) {
        return PropertyPath.create(source, type, "", base);
    }

    private static PropertyPath create(String source, TypeInformation<?> type, String addTail, List<PropertyPath> base) {
        if (base.size() > 1000) {
            throw new IllegalArgumentException(PARSE_DEPTH_EXCEEDED);
        }
        PropertyReferenceException exception = null;
        PropertyPath current = null;
        try {
            current = new PropertyPath(source, type, base);
            if (!base.isEmpty()) {
                base.get((int)(base.size() - 1)).next = current;
            }
            ArrayList<PropertyPath> newBase = new ArrayList<PropertyPath>(base);
            newBase.add(current);
            if (StringUtils.hasText((String)addTail)) {
                current.next = PropertyPath.create(addTail, current.actualTypeInformation, newBase);
            }
            return current;
        }
        catch (PropertyReferenceException e) {
            if (current != null) {
                throw e;
            }
            exception = e;
            Matcher matcher = NESTED_PROPERTY_PATTERN.matcher(source);
            if (matcher.find() && matcher.start() != 0) {
                int position = matcher.start();
                String head = source.substring(0, position);
                String tail = source.substring(position);
                try {
                    return PropertyPath.create(head, type, tail + addTail, base);
                }
                catch (PropertyReferenceException e2) {
                    throw e2.hasDeeperResolutionDepthThan(exception) ? e2 : exception;
                }
            }
            throw exception;
        }
    }

    public String toString() {
        return String.format("%s.%s", this.owningType.getType().getSimpleName(), this.toDotPath());
    }

    private static final class Property {
        private final TypeInformation<?> type;
        private final String path;

        private Property(TypeInformation<?> type, String path) {
            this.type = type;
            this.path = path;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Property)) {
                return false;
            }
            Property that = (Property)obj;
            return Objects.equals(this.type, that.type) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.path);
        }

        public String toString() {
            return "Key[type=" + this.type + ", path=" + this.path + "]";
        }
    }
}

