/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.Maintenance;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.AlarmRequest;
import io.etcd.jetcd.api.DefragmentRequest;
import io.etcd.jetcd.api.HashKVRequest;
import io.etcd.jetcd.api.MaintenanceGrpc;
import io.etcd.jetcd.api.MoveLeaderRequest;
import io.etcd.jetcd.api.SnapshotRequest;
import io.etcd.jetcd.api.SnapshotResponse;
import io.etcd.jetcd.api.StatusRequest;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.maintenance.AlarmMember;
import io.etcd.jetcd.maintenance.AlarmResponse;
import io.etcd.jetcd.maintenance.AlarmType;
import io.etcd.jetcd.maintenance.DefragmentResponse;
import io.etcd.jetcd.maintenance.HashKVResponse;
import io.etcd.jetcd.maintenance.MoveLeaderResponse;
import io.etcd.jetcd.maintenance.StatusResponse;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

final class MaintenanceImpl
implements Maintenance {
    private final ClientConnectionManager connectionManager;
    private final MaintenanceGrpc.MaintenanceFutureStub stub;
    private final MaintenanceGrpc.MaintenanceStub streamStub;

    MaintenanceImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(MaintenanceGrpc::newFutureStub);
        this.streamStub = connectionManager.newStub(MaintenanceGrpc::newStub);
    }

    @Override
    public CompletableFuture<AlarmResponse> listAlarms() {
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(io.etcd.jetcd.api.AlarmType.NONE).setAction(AlarmRequest.AlarmAction.GET).setMemberID(0L).build();
        return Util.toCompletableFuture(this.stub.alarm(alarmRequest), AlarmResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<AlarmResponse> alarmDisarm(AlarmMember member) {
        Preconditions.checkArgument((member.getMemberId() != 0L ? 1 : 0) != 0, (Object)"the member id can not be 0");
        Preconditions.checkArgument((member.getAlarmType() != AlarmType.NONE ? 1 : 0) != 0, (Object)"alarm type can not be NONE");
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(io.etcd.jetcd.api.AlarmType.NOSPACE).setAction(AlarmRequest.AlarmAction.DEACTIVATE).setMemberID(member.getMemberId()).build();
        return Util.toCompletableFuture(this.stub.alarm(alarmRequest), AlarmResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<DefragmentResponse> defragmentMember(URI endpoint) {
        return this.connectionManager.withNewChannel(endpoint, MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.defragment(DefragmentRequest.getDefaultInstance()), DefragmentResponse::new, this.connectionManager.getExecutorService()));
    }

    @Override
    public CompletableFuture<StatusResponse> statusMember(URI endpoint) {
        return this.connectionManager.withNewChannel(endpoint, MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.status(StatusRequest.getDefaultInstance()), StatusResponse::new, this.connectionManager.getExecutorService()));
    }

    @Override
    public CompletableFuture<MoveLeaderResponse> moveLeader(long transfereeID) {
        return Util.toCompletableFuture(this.stub.moveLeader(MoveLeaderRequest.newBuilder().setTargetID(transfereeID).build()), MoveLeaderResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<HashKVResponse> hashKV(URI endpoint, long rev) {
        return this.connectionManager.withNewChannel(endpoint, MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.hashKV(HashKVRequest.newBuilder().setRevision(rev).build()), HashKVResponse::new, this.connectionManager.getExecutorService()));
    }

    @Override
    public CompletableFuture<Long> snapshot(final OutputStream outputStream) {
        final CompletableFuture<Long> answer = new CompletableFuture<Long>();
        final AtomicLong bytes = new AtomicLong(0L);
        this.streamStub.snapshot(SnapshotRequest.getDefaultInstance(), new StreamObserver<SnapshotResponse>(){

            public void onNext(SnapshotResponse snapshotResponse) {
                try {
                    snapshotResponse.getBlob().writeTo(outputStream);
                    bytes.addAndGet(snapshotResponse.getBlob().size());
                }
                catch (IOException e) {
                    answer.completeExceptionally((Throwable)EtcdExceptionFactory.toEtcdException((Throwable)e));
                }
            }

            public void onError(Throwable throwable) {
                answer.completeExceptionally((Throwable)EtcdExceptionFactory.toEtcdException((Throwable)throwable));
            }

            public void onCompleted() {
                answer.complete(bytes.get());
            }
        });
        return answer;
    }

    @Override
    public void snapshot(final StreamObserver<io.etcd.jetcd.maintenance.SnapshotResponse> observer) {
        this.streamStub.snapshot(SnapshotRequest.getDefaultInstance(), new StreamObserver<SnapshotResponse>(){

            public void onNext(SnapshotResponse snapshotResponse) {
                observer.onNext((Object)new io.etcd.jetcd.maintenance.SnapshotResponse(snapshotResponse));
            }

            public void onError(Throwable throwable) {
                observer.onError((Throwable)EtcdExceptionFactory.toEtcdException((Throwable)throwable));
            }

            public void onCompleted() {
                observer.onCompleted();
            }
        });
    }
}

