/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.combiner;

import org.apache.hugegraph.computer.core.combiner.AbstractPointerCombiner;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.StreamGraphInput;
import org.apache.hugegraph.computer.core.store.entry.InlinePointer;
import org.apache.hugegraph.computer.core.store.entry.Pointer;

public class VertexValueCombiner
extends AbstractPointerCombiner<Properties> {
    public VertexValueCombiner(ComputerContext context) {
        super(() -> context.graphFactory().createProperties(), (Combiner)context.config().createObject(ComputerOptions.WORKER_VERTEX_PROPERTIES_COMBINER_CLASS));
    }

    @Override
    public Pointer combine(Pointer v1, Pointer v2) {
        try {
            RandomAccessInput input1 = v1.input();
            RandomAccessInput input2 = v2.input();
            input1.seek(v1.offset());
            input2.seek(v2.offset());
            String label1 = StreamGraphInput.readLabel(input1);
            String label2 = StreamGraphInput.readLabel(input2);
            assert (label1.equals(label2));
            ((Properties)this.v1).read(input1);
            ((Properties)this.v2).read(input2);
            this.combiner.combine((Object)((Properties)this.v1), (Object)((Properties)this.v2), (Object)((Properties)this.result));
            this.output.seek(0L);
            this.output.writeUTF(label1);
            ((Properties)this.result).write((RandomAccessOutput)this.output);
            return new InlinePointer(this.output.buffer(), this.output.position());
        }
        catch (Exception e) {
            throw new ComputerException("Failed to combine pointer1(offset=%s, length=%s) and pointer2(offset=%s, length=%s)'", (Throwable)e, new Object[]{v1.offset(), v1.length(), v2.offset(), v2.length()});
        }
    }
}

