/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.hgkvfile;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.AbstractHgkvFile;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvFile;
import org.apache.hugegraph.util.E;

public class HgkvFileImpl
extends AbstractHgkvFile {
    public HgkvFileImpl(String path) {
        super(path);
    }

    public static HgkvFile create(String path) throws IOException {
        File file = new File(path);
        E.checkArgument((!file.exists() ? 1 : 0) != 0, (String)"Can't create HgkvFile because the file already exists: '%s'", (Object[])new Object[]{file.getPath()});
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        return new HgkvFileImpl(path);
    }

    public static HgkvFile open(String path) throws IOException {
        E.checkArgumentNotNull((Object)path, (String)"Parameter path can't be null", (Object[])new Object[0]);
        return HgkvFileImpl.open(new File(path));
    }

    public static HgkvFile open(File file) throws IOException {
        E.checkArgumentNotNull((Object)file, (String)"Parameter file can't be null", (Object[])new Object[0]);
        E.checkArgument((boolean)file.exists(), (String)"Failed to open path because the file does not exists: '%s'", (Object[])new Object[]{file.getPath()});
        E.checkArgument((boolean)file.isFile(), (String)"Failed to open path because it's not a file: '%s'", (Object[])new Object[]{file.getPath()});
        HgkvFileImpl hgkvFile = new HgkvFileImpl(file.getPath());
        hgkvFile.readFooter();
        return hgkvFile;
    }

    private static String version(short majorVersion, short minorVersion) {
        return StringUtils.join((Object[])new Serializable[]{Short.valueOf(majorVersion), ".", Short.valueOf(minorVersion)});
    }

    @Override
    public RandomAccessOutput output() throws IOException {
        return IOFactory.createFileOutput(new File(this.path));
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readFooter() throws IOException {
        File file = new File(this.path);
        long versionOffset = file.length() - 4L - 4L;
        try (RandomAccessInput input = IOFactory.createFileInput(file);){
            input.seek(versionOffset);
            short majorVersion = input.readShort();
            short minorVersion = input.readShort();
            String version = HgkvFileImpl.version(majorVersion, minorVersion);
            int footerLength = input.readFixedInt();
            switch (version) {
                case "1.0": {
                    this.readFooterV1d0(input, file.length() - (long)footerLength);
                    return;
                }
                default: {
                    throw new ComputerException("Illegal HgkvFile version '%s'", new Object[]{version});
                }
            }
        }
    }

    private void readFooterV1d0(RandomAccessInput input, long footerBegin) throws IOException {
        input.seek(footerBegin);
        String magic = new String(input.readBytes(MAGIC.length()));
        E.checkArgument((boolean)MAGIC.equals(magic), (String)"Failed to read footer, illegal hgvk-file magic in file: '%s'", (Object[])new Object[]{this.path});
        this.magic = magic;
        this.numEntries = input.readLong();
        this.numSubEntries = input.readLong();
        this.dataBlockSize = input.readLong();
        this.indexBlockSize = input.readLong();
        long maxKeyOffset = input.readLong();
        long minKeyOffset = input.readLong();
        short majorVersion = input.readShort();
        short minorVersion = input.readShort();
        this.version = HgkvFileImpl.version(majorVersion, minorVersion);
        if (this.numEntries > 0L) {
            input.seek(maxKeyOffset);
            int maxKeyLength = input.readFixedInt();
            this.max = input.readBytes(maxKeyLength);
            input.seek(minKeyOffset);
            int minKeyLength = input.readFixedInt();
            this.min = input.readBytes(minKeyLength);
        }
    }
}

