/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.BytesInput;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.Readable;
import org.apache.hugegraph.computer.core.io.Writable;

public final class SerializeUtil {
    public static byte[] toBytes(Writable obj) {
        byte[] byArray;
        block8: {
            BytesOutput bao = IOFactory.createBytesOutput(32);
            try {
                obj.write((RandomAccessOutput)bao);
                byArray = bao.toByteArray();
                if (bao == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bao != null) {
                        try {
                            bao.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ComputerException("Failed to create byte array with writable '%s'", (Throwable)e, new Object[]{obj});
                }
            }
            bao.close();
        }
        return byArray;
    }

    public static byte[] toBytes(List<? extends Writable> list) {
        Object object;
        block9: {
            BytesOutput bao = IOFactory.createBytesOutput(32);
            try {
                bao.writeInt(list.size());
                for (Writable writable : list) {
                    writable.write((RandomAccessOutput)bao);
                }
                object = bao.toByteArray();
                if (bao == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (bao != null) {
                        try {
                            bao.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ComputerException("Failed to create byte array with List<Writable> '%s'", (Throwable)e, new Object[]{list});
                }
            }
            bao.close();
        }
        return object;
    }

    public static void fromBytes(byte[] bytes, Readable obj) {
        try (BytesInput bai = IOFactory.createBytesInput(bytes);){
            obj.read((RandomAccessInput)bai);
        }
        catch (IOException e) {
            throw new ComputerException("Failed to read from byte array", (Throwable)e);
        }
    }

    public static <V extends Readable> List<V> fromBytes(byte[] bytes, Supplier<V> supplier) {
        ArrayList<Readable> arrayList;
        block9: {
            BytesInput bai = IOFactory.createBytesInput(bytes);
            try {
                int size = bai.readInt();
                ArrayList<Readable> list = new ArrayList<Readable>(size);
                for (int i = 0; i < size; ++i) {
                    Readable obj = (Readable)supplier.get();
                    obj.read((RandomAccessInput)bai);
                    list.add(obj);
                }
                arrayList = list;
                if (bai == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (bai != null) {
                        try {
                            bai.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ComputerException("Failed to read from byte array", (Throwable)e);
                }
            }
            bai.close();
        }
        return arrayList;
    }
}

