/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.output.hg.metrics;

import org.apache.hugegraph.computer.core.output.hg.metrics.LoadReport;
import org.apache.hugegraph.computer.core.output.hg.metrics.LoadSummary;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.TimeUtil;
import org.slf4j.Logger;

public final class Printer {
    private static final Logger LOG = Log.logger(Printer.class);

    public static void printSummary(LoadSummary summary) {
        Printer.printCountReport(LoadReport.collect(summary));
        Printer.printMeterReport(summary);
    }

    private static void printCountReport(LoadReport report) {
        Printer.log("count metrics");
        Printer.log("vertex insert success", report.vertexInsertSuccess());
        Printer.log("vertex insert failure", report.vertexInsertFailure());
    }

    private static void printMeterReport(LoadSummary summary) {
        Printer.log("meter metrics");
        Printer.log("total time", TimeUtil.readableTime(summary.totalTime()));
        Printer.log("vertex load rate(vertices/s)", summary.loadRate());
    }

    private static void log(String message) {
        LOG.info(message);
    }

    private static void log(String key, long value) {
        LOG.info(String.format("    %-30s: %-20d", key, value));
    }

    private static void log(String key, String value) {
        LOG.info(String.format("    %-30s: %-20s", key, value));
    }
}

