/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.operator.common;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.computer.driver.util.JsonUtil;
import org.apache.hugegraph.util.E;

public class OperatorRequest {
    private String namespace;
    private String name;
    private final AtomicInteger retryTimes;

    public static OperatorRequest parseRequestByCR(CustomResource<?, ?> resource) {
        E.checkNotNull(resource, "resource");
        ObjectMeta metadata = resource.getMetadata();
        E.checkNotNull(resource, "metadata");
        String name = metadata.getName();
        E.checkArgument(StringUtils.isNotBlank(name), "resourceName", new Object[0]);
        return new OperatorRequest(metadata.getNamespace(), name);
    }

    public OperatorRequest(String name) {
        this(null, name);
    }

    public OperatorRequest(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        this.retryTimes = new AtomicInteger(0);
    }

    public String name() {
        return this.name;
    }

    public OperatorRequest name(String name) {
        this.name = name;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public OperatorRequest namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String key() {
        return Cache.namespaceKeyFunc(this.namespace, this.name);
    }

    public int retryIncrGet() {
        return this.retryTimes.incrementAndGet();
    }

    public int retryTimes() {
        return this.retryTimes.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OperatorRequest)) {
            return false;
        }
        OperatorRequest other = (OperatorRequest)obj;
        return Objects.equals(other.namespace, this.namespace) && Objects.equals(other.name, this.name);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }

    public String toString() {
        return JsonUtil.toJson(this);
    }
}

