/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Iterator;
import java.util.Queue;
import org.apache.bifromq.basekv.client.IQueryPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchQueryCall;
import org.apache.bifromq.basekv.client.scheduler.QueryCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.server.scheduler.FetchRequest;
import org.apache.bifromq.inbox.storage.proto.BatchFetchRequest;
import org.apache.bifromq.inbox.storage.proto.Fetched;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcInput;

class BatchFetchCall
extends BatchQueryCall<FetchRequest, Fetched> {
    protected BatchFetchCall(IQueryPipeline pipeline, QueryCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected ROCoProcInput makeBatch(Iterator<FetchRequest> reqIterator) {
        BatchFetchRequest.Builder reqBuilder = BatchFetchRequest.newBuilder();
        reqIterator.forEachRemaining(request -> {
            BatchFetchRequest.Params.Builder paramsBuilder = BatchFetchRequest.Params.newBuilder().setTenantId(request.tenantId()).setInboxId(request.inboxId()).setIncarnation(request.incarnation()).setMaxFetch(request.params().getMaxFetch());
            if (request.params().hasQos0StartAfter()) {
                paramsBuilder.setQos0StartAfter(request.params().getQos0StartAfter());
            }
            if (request.params().hasSendBufferStartAfter()) {
                paramsBuilder.setSendBufferStartAfter(request.params().getSendBufferStartAfter());
            }
            reqBuilder.addParams(paramsBuilder.build());
        });
        long reqId = System.nanoTime();
        return ROCoProcInput.newBuilder().setInboxService(InboxServiceROCoProcInput.newBuilder().setReqId(reqId).setBatchFetch(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<FetchRequest, Fetched, QueryCallBatcherKey>> batchedTasks, ROCoProcOutput output) {
        ICallTask<FetchRequest, Fetched, QueryCallBatcherKey> task;
        int i = 0;
        while ((task = batchedTasks.poll()) != null) {
            task.resultPromise().complete(output.getInboxService().getBatchFetch().getResult(i++));
        }
    }

    protected void handleException(ICallTask<FetchRequest, Fetched, QueryCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(Fetched.newBuilder().setResult(Fetched.Result.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(Fetched.newBuilder().setResult(Fetched.Result.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(Fetched.newBuilder().setResult(Fetched.Result.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }
}

