/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.propagation.ExtendedContextPropagators;
import io.opentelemetry.api.incubator.trace.ExtendedSpanBuilder;
import io.opentelemetry.api.incubator.trace.ExtendedTracer;
import io.opentelemetry.api.incubator.trace.SpanCallable;
import io.opentelemetry.api.incubator.trace.SpanRunnable;
import io.opentelemetry.api.internal.ApiUsageLogger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class ExtendedDefaultTracer
implements ExtendedTracer {
    private static final Tracer INSTANCE = new ExtendedDefaultTracer();

    static Tracer getNoop() {
        return INSTANCE;
    }

    public SpanBuilder spanBuilder(String spanName) {
        return NoopSpanBuilder.create();
    }

    private ExtendedDefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements ExtendedSpanBuilder {
        @Nullable
        private SpanContext spanContext;

        static NoopSpanBuilder create() {
            return new NoopSpanBuilder();
        }

        public Span startSpan() {
            if (this.spanContext == null) {
                this.spanContext = Span.current().getSpanContext();
            }
            return Span.wrap((SpanContext)this.spanContext);
        }

        @Override
        public NoopSpanBuilder setParent(Context context) {
            if (context == null) {
                ApiUsageLogger.log((String)"context is null");
                return this;
            }
            this.spanContext = Span.fromContext((Context)context).getSpanContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setParentFrom(ContextPropagators propagators, Map<String, String> carrier) {
            this.setParent(ExtendedContextPropagators.extractTextMapPropagationContext(carrier, propagators));
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.spanContext = SpanContext.getInvalid();
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value) {
            return this;
        }

        @Override
        public <T> NoopSpanBuilder setAttribute(AttributeKey<T> key, T value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAllAttributes(Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(SpanKind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
            return this;
        }

        @Override
        public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable) throws E {
            return spanCallable.callInSpan();
        }

        @Override
        public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable, BiConsumer<Span, Throwable> handleException) throws E {
            return spanCallable.callInSpan();
        }

        @Override
        public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable) throws E {
            runnable.runInSpan();
        }

        @Override
        public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable, BiConsumer<Span, Throwable> handleException) throws E {
            runnable.runInSpan();
        }

        private NoopSpanBuilder() {
        }
    }
}

