/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.AuthenticationParameters;

@ApiModel(description="OAuth authentication based on client_id/client_secret")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OAuthClientCredentialsParameters
extends AuthenticationParameters {
    private final String tokenUri;
    private final String clientId;
    private final String clientSecret;
    private final List<String> scopes;

    @ApiModelProperty(value="Token server URI")
    @JsonProperty(value="tokenUri")
    public String getTokenUri() {
        return this.tokenUri;
    }

    @ApiModelProperty(value="oauth client id")
    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @ApiModelProperty(value="oauth client secret (input-only)")
    @JsonProperty(value="clientSecret")
    public String getClientSecret() {
        return this.clientSecret;
    }

    @ApiModelProperty(value="oauth scopes to specify when exchanging for a short-lived access token")
    @JsonProperty(value="scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonCreator
    public OAuthClientCredentialsParameters(@JsonProperty(value="tokenUri") String tokenUri, @JsonProperty(value="clientId") String clientId, @JsonProperty(value="clientSecret") String clientSecret, @JsonProperty(value="scopes") List<String> scopes, @JsonProperty(value="authenticationType", required=true) AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.tokenUri = tokenUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scopes = Objects.requireNonNullElse(scopes, new ArrayList());
    }

    public OAuthClientCredentialsParameters(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.tokenUri = null;
        this.clientId = null;
        this.clientSecret = null;
        this.scopes = new ArrayList<String>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
        return new Builder(authenticationType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthClientCredentialsParameters oauthClientCredentialsParameters = (OAuthClientCredentialsParameters)o;
        return super.equals(o) && Objects.equals(this.tokenUri, oauthClientCredentialsParameters.tokenUri) && Objects.equals(this.clientId, oauthClientCredentialsParameters.clientId) && Objects.equals(this.clientSecret, oauthClientCredentialsParameters.clientSecret) && Objects.equals(this.scopes, oauthClientCredentialsParameters.scopes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tokenUri, super.hashCode(), this.clientId, super.hashCode(), this.clientSecret, super.hashCode(), this.scopes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthClientCredentialsParameters {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    tokenUri: ").append(this.toIndentedString(this.tokenUri)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append("*").append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String tokenUri;
        private String clientId;
        private String clientSecret;
        private List<String> scopes;
        private AuthenticationParameters.AuthenticationTypeEnum authenticationType;

        private Builder() {
        }

        private Builder(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
            this.authenticationType = authenticationType;
        }

        public Builder setTokenUri(String tokenUri) {
            this.tokenUri = tokenUri;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setScopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder setAuthenticationType(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public OAuthClientCredentialsParameters build() {
            OAuthClientCredentialsParameters inst = new OAuthClientCredentialsParameters(this.tokenUri, this.clientId, this.clientSecret, this.scopes, this.authenticationType);
            return inst;
        }
    }
}

