/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.configuration.DurationConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;

@ConfigGroup
public interface CrtHttpClientConfig {
    @ConfigDocDefault(value="60S")
    @WithConverter(value=DurationConverter.class)
    public Optional<Duration> connectionMaxIdleTime();

    @ConfigDocDefault(value="50")
    public Optional<Integer> maxConcurrency();

    public HttpClientProxyConfiguration proxy();

    public TcpKeepAliveConfiguration tcpKeepAlive();

    @ConfigGroup
    public static interface TcpKeepAliveConfiguration {
        @WithDefault(value="false")
        public boolean enabled();

        @WithDefault(value="75ms")
        @WithConverter(value=DurationConverter.class)
        public Duration keepAliveInterval();

        @WithDefault(value="7200ms")
        @WithConverter(value=DurationConverter.class)
        public Duration keepAliveTimeout();

        @WithDefault(value="9")
        public Integer keepAliveProbes();
    }

    @ConfigGroup
    public static interface HttpClientProxyConfiguration {
        @WithDefault(value="false")
        public boolean enabled();

        public Optional<URI> endpoint();

        public Optional<String> username();

        public Optional<String> password();
    }
}

