/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.fory.Fory;
import org.apache.fory.collection.LazyMap;
import org.apache.fory.collection.MapSnapshot;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.ReplaceResolveSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.serializer.StringSerializer;
import org.apache.fory.serializer.collection.ConcurrentMapSerializer;
import org.apache.fory.serializer.collection.MapLikeSerializer;
import org.apache.fory.serializer.collection.MapSerializer;
import org.apache.fory.util.Preconditions;

public class MapSerializers {
    public static void registerDefaultSerializers(Fory fory) {
        ClassResolver resolver = fory.getClassResolver();
        resolver.registerSerializer(HashMap.class, new HashMapSerializer(fory));
        fory.getClassResolver().registerSerializer(LinkedHashMap.class, new LinkedHashMapSerializer(fory));
        resolver.registerSerializer(TreeMap.class, new SortedMapSerializer<TreeMap>(fory, TreeMap.class));
        resolver.registerSerializer(Collections.EMPTY_MAP.getClass(), new EmptyMapSerializer(fory, Collections.EMPTY_MAP.getClass()));
        resolver.registerSerializer(Collections.emptySortedMap().getClass(), new EmptySortedMapSerializer(fory, Collections.emptySortedMap().getClass()));
        resolver.registerSerializer(Collections.singletonMap(null, null).getClass(), new SingletonMapSerializer(fory, Collections.singletonMap(null, null).getClass()));
        resolver.registerSerializer(ConcurrentHashMap.class, new ConcurrentHashMapSerializer(fory, ConcurrentHashMap.class));
        resolver.registerSerializer(ConcurrentSkipListMap.class, new ConcurrentSkipListMapSerializer(fory, ConcurrentSkipListMap.class));
        resolver.registerSerializer(EnumMap.class, new EnumMapSerializer(fory));
        resolver.registerSerializer(LazyMap.class, new LazyMapSerializer(fory));
    }

    public static class JDKCompatibleMapSerializer<T>
    extends MapLikeSerializer<T> {
        private final Serializer serializer;

        public JDKCompatibleMapSerializer(Fory fory, Class<T> cls) {
            super(fory, cls, false);
            Class serializerType = ClassResolver.useReplaceResolveSerializer(cls) ? ReplaceResolveSerializer.class : fory.getDefaultJDKStreamSerializerType();
            this.serializer = Serializers.newSerializer(fory, cls, serializerType);
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, T value) {
            throw new IllegalStateException();
        }

        @Override
        public T onMapCopy(Map map) {
            throw new IllegalStateException();
        }

        @Override
        public T onMapRead(Map map) {
            throw new IllegalStateException();
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.serializer.read(buffer);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.serializer.write(buffer, value);
        }

        @Override
        public T copy(T value) {
            return this.fory.copyObject(value, this.serializer);
        }
    }

    public static final class DefaultJavaMapSerializer<T>
    extends MapLikeSerializer<T> {
        private Serializer<T> dataSerializer;

        public DefaultJavaMapSerializer(Fory fory, Class<T> cls) {
            super(fory, cls, false);
            Preconditions.checkArgument(!fory.isCrossLanguage(), "Fory cross-language default map serializer should use " + MapSerializer.class);
            fory.getClassResolver().setSerializer(cls, this);
            Class<? extends Serializer> serializerClass = fory.getClassResolver().getObjectSerializerClass(cls, sc -> {
                this.dataSerializer = Serializers.newSerializer(fory, cls, sc);
            });
            this.dataSerializer = Serializers.newSerializer(fory, cls, serializerClass);
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, T value) {
            throw new IllegalStateException();
        }

        @Override
        public T onMapCopy(Map map) {
            throw new IllegalStateException();
        }

        @Override
        public T onMapRead(Map map) {
            throw new IllegalStateException();
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.dataSerializer.write(buffer, value);
        }

        @Override
        public T copy(T value) {
            return this.fory.copyObject(value, this.dataSerializer);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.dataSerializer.read(buffer);
        }
    }

    public static class StringKeyMapSerializer<T>
    extends MapSerializer<Map<String, T>> {
        public StringKeyMapSerializer(Fory fory, Class<Map<String, T>> cls) {
            super(fory, cls, false);
            this.setKeySerializer(new StringSerializer(fory));
        }

        @Override
        public void write(MemoryBuffer buffer, Map<String, T> value) {
            buffer.writeVarUint32Small7(value.size());
            for (Map.Entry<String, T> e : value.entrySet()) {
                this.fory.writeJavaStringRef(buffer, e.getKey());
                this.fory.writeRef(buffer, e.getValue());
            }
        }

        @Override
        public Map<String, T> read(MemoryBuffer buffer) {
            Map map = this.newMap(buffer);
            int numElements = this.getAndClearNumElements();
            for (int i = 0; i < numElements; ++i) {
                map.put(this.fory.readJavaStringRef(buffer), this.fory.readRef(buffer));
            }
            return map;
        }

        @Override
        protected <K, V> void copyEntry(Map<K, V> originMap, Map<K, V> newMap) {
            ClassResolver classResolver = this.fory.getClassResolver();
            for (Map.Entry<K, V> entry : originMap.entrySet()) {
                ClassInfo classInfo;
                V value = entry.getValue();
                if (value != null && !(classInfo = classResolver.getClassInfo(value.getClass(), this.valueClassInfoWriteCache)).getSerializer().isImmutable()) {
                    value = this.fory.copyObject(value, classInfo.getClassId());
                }
                newMap.put(entry.getKey(), value);
            }
        }
    }

    public static class EnumMapSerializer
    extends MapSerializer<EnumMap> {
        private static final long keyTypeFieldOffset;

        public EnumMapSerializer(Fory fory) {
            super(fory, EnumMap.class, true);
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, EnumMap value) {
            buffer.writeVarUint32Small7(value.size());
            Class keyType = (Class)Platform.getObject(value, keyTypeFieldOffset);
            this.fory.getClassResolver().writeClassAndUpdateCache(buffer, keyType);
            return value;
        }

        @Override
        public EnumMap newMap(MemoryBuffer buffer) {
            this.setNumElements(buffer.readVarUint32Small7());
            Class<?> keyType = this.fory.getClassResolver().readClassInfo(buffer).getCls();
            return new EnumMap(keyType);
        }

        @Override
        public EnumMap copy(EnumMap originMap) {
            return new EnumMap(originMap);
        }

        static {
            try {
                keyTypeFieldOffset = Platform.objectFieldOffset(EnumMap.class.getDeclaredField("keyType"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class ConcurrentSkipListMapSerializer
    extends ConcurrentMapSerializer<ConcurrentSkipListMap> {
        public ConcurrentSkipListMapSerializer(Fory fory, Class<ConcurrentSkipListMap> cls) {
            super(fory, cls, true);
        }

        @Override
        public MapSnapshot onMapWrite(MemoryBuffer buffer, ConcurrentSkipListMap value) {
            Map snapshot = super.onMapWrite(buffer, value);
            if (!this.fory.isCrossLanguage()) {
                this.fory.writeRef(buffer, value.comparator());
            }
            return snapshot;
        }

        @Override
        public ConcurrentSkipListMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            Comparator comparator = (Comparator)this.fory.readRef(buffer);
            ConcurrentSkipListMap map = new ConcurrentSkipListMap(comparator);
            this.fory.getRefResolver().reference(map);
            return map;
        }

        @Override
        public Map newMap(Map originMap) {
            Comparator comparator = this.fory.copyObject(((ConcurrentSkipListMap)originMap).comparator());
            return new ConcurrentSkipListMap(comparator);
        }
    }

    public static final class ConcurrentHashMapSerializer
    extends ConcurrentMapSerializer<ConcurrentHashMap> {
        public ConcurrentHashMapSerializer(Fory fory, Class<ConcurrentHashMap> type) {
            super(fory, type, true);
        }

        @Override
        public ConcurrentHashMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            ConcurrentHashMap map = new ConcurrentHashMap(numElements);
            this.fory.getRefResolver().reference(map);
            return map;
        }

        @Override
        public Map newMap(Map map) {
            return new ConcurrentHashMap(map.size());
        }
    }

    public static final class SingletonMapSerializer
    extends MapSerializer<Map<?, ?>> {
        public SingletonMapSerializer(Fory fory, Class<Map<?, ?>> cls) {
            super(fory, cls, fory.isCrossLanguage());
        }

        @Override
        public Map<?, ?> copy(Map<?, ?> originMap) {
            Map.Entry<?, ?> entry = originMap.entrySet().iterator().next();
            return Collections.singletonMap(this.fory.copyObject(entry.getKey()), this.fory.copyObject(entry.getValue()));
        }

        @Override
        public void write(MemoryBuffer buffer, Map<?, ?> value) {
            Map.Entry<?, ?> entry = value.entrySet().iterator().next();
            this.fory.writeRef(buffer, entry.getKey());
            this.fory.writeRef(buffer, entry.getValue());
        }

        @Override
        public Map<?, ?> read(MemoryBuffer buffer) {
            Object key = this.fory.readRef(buffer);
            Object value = this.fory.readRef(buffer);
            return Collections.singletonMap(key, value);
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Map<?, ?> value) {
            super.write(buffer, value);
        }

        @Override
        public Map<?, ?> xread(MemoryBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class EmptySortedMapSerializer
    extends MapSerializer<SortedMap<?, ?>> {
        public EmptySortedMapSerializer(Fory fory, Class<SortedMap<?, ?>> cls) {
            super(fory, cls, fory.isCrossLanguage(), true);
        }

        @Override
        public void write(MemoryBuffer buffer, SortedMap<?, ?> value) {
        }

        @Override
        public SortedMap<?, ?> read(MemoryBuffer buffer) {
            return Collections.emptySortedMap();
        }
    }

    public static final class EmptyMapSerializer
    extends MapSerializer<Map<?, ?>> {
        public EmptyMapSerializer(Fory fory, Class<Map<?, ?>> cls) {
            super(fory, cls, fory.isCrossLanguage(), true);
        }

        @Override
        public void write(MemoryBuffer buffer, Map<?, ?> value) {
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Map<?, ?> value) {
            super.write(buffer, value);
        }

        @Override
        public Map<?, ?> read(MemoryBuffer buffer) {
            return Collections.EMPTY_MAP;
        }

        @Override
        public Map<?, ?> xread(MemoryBuffer buffer) {
            throw new IllegalStateException();
        }
    }

    public static class SortedMapSerializer<T extends SortedMap>
    extends MapSerializer<T> {
        public SortedMapSerializer(Fory fory, Class<T> cls) {
            super(fory, cls, true);
            if (cls != TreeMap.class) {
                this.constructor = ReflectionUtils.getCtrHandle(cls, Comparator.class);
            }
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, T value) {
            buffer.writeVarUint32Small7(value.size());
            if (!this.fory.isCrossLanguage()) {
                this.fory.writeRef(buffer, value.comparator());
            }
            return value;
        }

        @Override
        public Map newMap(MemoryBuffer buffer) {
            SortedMap map;
            assert (!this.fory.isCrossLanguage());
            this.setNumElements(buffer.readVarUint32Small7());
            Comparator comparator = (Comparator)this.fory.readRef(buffer);
            if (this.type == TreeMap.class) {
                map = new TreeMap(comparator);
            } else {
                try {
                    map = this.constructor.invoke(comparator);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            this.fory.getRefResolver().reference(map);
            return map;
        }

        @Override
        public Map newMap(Map originMap) {
            Map map;
            Comparator comparator = this.fory.copyObject(((SortedMap)originMap).comparator());
            if (this.type == TreeMap.class) {
                map = new TreeMap(comparator);
            } else {
                try {
                    map = this.constructor.invoke(comparator);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return map;
        }
    }

    public static final class LazyMapSerializer
    extends MapSerializer<LazyMap> {
        public LazyMapSerializer(Fory fory) {
            super(fory, LazyMap.class, true);
        }

        @Override
        public LazyMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            LazyMap map = new LazyMap(numElements);
            this.fory.getRefResolver().reference(map);
            return map;
        }

        @Override
        public Map newMap(Map map) {
            return new LazyMap(map.size());
        }
    }

    public static final class LinkedHashMapSerializer
    extends MapSerializer<LinkedHashMap> {
        public LinkedHashMapSerializer(Fory fory) {
            super(fory, LinkedHashMap.class, true);
        }

        @Override
        public LinkedHashMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            LinkedHashMap hashMap = new LinkedHashMap(numElements);
            this.fory.getRefResolver().reference(hashMap);
            return hashMap;
        }

        @Override
        public Map newMap(Map map) {
            return new LinkedHashMap(map.size());
        }
    }

    public static final class HashMapSerializer
    extends MapSerializer<HashMap> {
        public HashMapSerializer(Fory fory) {
            super(fory, HashMap.class, true);
        }

        @Override
        public HashMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            HashMap hashMap = new HashMap(numElements);
            this.fory.getRefResolver().reference(hashMap);
            return hashMap;
        }

        @Override
        public Map newMap(Map map) {
            return new HashMap(map.size());
        }
    }
}

