/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.NettyRuntime;
import io.netty.util.internal.PlatformDependent;
import org.apache.commons.lang3.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;

public class NettyBaseConfig {
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected static final String BOSS_THREAD_PREFIX = CONFIG.getConfig("transport.threadFactory.bossThreadPrefix");
    protected static final String WORKER_THREAD_PREFIX = CONFIG.getConfig("transport.threadFactory.workerThreadPrefix");
    protected static final boolean SHARE_BOSS_WORKER = CONFIG.getBoolean("transport.threadFactory.shareBossWorker");
    protected static final int WORKER_THREAD_SIZE;
    protected static final Class<? extends ServerChannel> SERVER_CHANNEL_CLAZZ;
    protected static final Class<? extends Channel> CLIENT_CHANNEL_CLAZZ;
    private static final int DEFAULT_WRITE_IDLE_SECONDS = 5;
    private static final int READIDLE_BASE_WRITEIDLE = 3;
    protected static final int MAX_WRITE_IDLE_SECONDS;
    protected static final int MAX_READ_IDLE_SECONDS;
    protected static final int MAX_ALL_IDLE_SECONDS = 0;

    static {
        String workerThreadSize = CONFIG.getConfig("transport.threadFactory.workerThreadSize");
        WORKER_THREAD_SIZE = StringUtils.isNotBlank((CharSequence)workerThreadSize) && StringUtils.isNumeric((CharSequence)workerThreadSize) ? Integer.parseInt(workerThreadSize) : (WorkThreadMode.getModeByName(workerThreadSize) != null ? WorkThreadMode.getModeByName(workerThreadSize).getValue() : WorkThreadMode.Default.getValue());
        boolean useEpoll = !PlatformDependent.isWindows() && !PlatformDependent.isOsx() && Epoll.isAvailable();
        SERVER_CHANNEL_CLAZZ = useEpoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
        CLIENT_CHANNEL_CLAZZ = useEpoll ? EpollSocketChannel.class : NioSocketChannel.class;
        boolean enableHeartbeat = CONFIG.getBoolean("transport.heartbeat", true);
        MAX_WRITE_IDLE_SECONDS = enableHeartbeat ? 5 : 0;
        MAX_READ_IDLE_SECONDS = MAX_WRITE_IDLE_SECONDS * 3;
    }

    public static enum WorkThreadMode {
        Auto(NettyRuntime.availableProcessors() * 2 + 1),
        Pin(NettyRuntime.availableProcessors()),
        BusyPin(NettyRuntime.availableProcessors() + 1),
        Default(NettyRuntime.availableProcessors() * 2);

        private int value;

        public int getValue() {
            return this.value;
        }

        private WorkThreadMode(int value) {
            this.value = value;
        }

        public static WorkThreadMode getModeByName(String name) {
            for (WorkThreadMode mode : WorkThreadMode.values()) {
                if (!mode.name().equalsIgnoreCase(name)) continue;
                return mode;
            }
            return null;
        }
    }
}

