/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.seata.protocol.transaction;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.seata.core.protocol.transaction.GlobalBeginResponse;
import org.apache.seata.serializer.seata.protocol.transaction.AbstractTransactionResponseCodec;

public class GlobalBeginResponseCodec
extends AbstractTransactionResponseCodec {
    @Override
    public Class<?> getMessageClassType() {
        return GlobalBeginResponse.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        byte[] bs;
        super.encode(t, out);
        GlobalBeginResponse globalBeginResponse = (GlobalBeginResponse)t;
        String xid = globalBeginResponse.getXid();
        String extraData = globalBeginResponse.getExtraData();
        if (xid != null) {
            bs = xid.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
        if (extraData != null) {
            bs = extraData.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        byte[] bs;
        super.decode(t, in);
        GlobalBeginResponse globalBeginResponse = (GlobalBeginResponse)t;
        short len = in.getShort();
        if (len > 0) {
            bs = new byte[len];
            in.get(bs);
            globalBeginResponse.setXid(new String(bs, UTF8));
        }
        if ((len = in.getShort()) > 0) {
            bs = new byte[len];
            in.get(bs);
            globalBeginResponse.setExtraData(new String(bs, UTF8));
        }
    }
}

